/*
 *  mdaBeatBoxProcessor.h
 *  mda-vst3
 *
 *  Created by Arne Scheffler on 6/14/08.
 *
 *  mda VST Plug-ins
 *
 *  Copyright (c) 2008 Paul Kellett
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above copyright notice and this
 * permission notice shall be included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#pragma once

#include "mdaBaseProcessor.h"

namespace Steinberg {
namespace Vst {
namespace mda {

class BeatBoxProcessor : public BaseProcessor
{
public:
	BeatBoxProcessor ();

	int32 getVst2UniqueId () const SMTG_OVERRIDE { return 'mdaG'; }

	tresult PLUGIN_API initialize (FUnknown* context) SMTG_OVERRIDE;
	tresult PLUGIN_API setActive (TBool state) SMTG_OVERRIDE;
	tresult PLUGIN_API setProcessing (TBool state) SMTG_OVERRIDE;

	void doProcessing (ProcessData& data) SMTG_OVERRIDE;

//-----------------------------------------------------------------------------
	static FUnknown* createInstance (void*) { return (IAudioProcessor*)new BeatBoxProcessor; }

#ifdef SMTG_MDA_VST2_COMPATIBILITY
	inline static DECLARE_UID (uid, 0x5653546D, 0x6461476D, 0x64612062, 0x65617462);
#else
	inline static DECLARE_UID (uid, 0x9E6A6E95, 0x9B734440, 0x97D787BE, 0xBBDDD831);
#endif

//-----------------------------------------------------------------------------
protected:
	void recalculate () SMTG_OVERRIDE;

	float hthr, hfil, sthr, kthr, kfil1, kfil2, mix;
	float klev, hlev, slev;
	float ww, wwx, sb1, sb2, sf1, sf2, sf3;
	float kww, kwwx, ksb1, ksb2, ksf1, ksf2;
	float dyne, dyna, dynr, dynm;

	float *hbuf;
	float *kbuf;
	float *sbuf, *sbuf2;
	int32 hbuflen, hbufpos, hdel;
	int32 sbuflen, sbufpos, sdel, sfx;
	int32 kbuflen, kbufpos, kdel, ksfx;
	int32 rec, recx, recpos;
};

}}} // namespaces
