/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.model;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import groovy.lang.GroovyObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Function;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.cache.Cache;
import org.gradle.cache.internal.ClassCacheFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.state.Managed;
import org.gradle.internal.state.ManagedFactory;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.asm.ClassGeneratorSuffixRegistry;
import org.gradle.model.internal.asm.ClassVisitorScope;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.gradle.model.internal.inspect.FormattingValidationProblemCollector;
import org.gradle.model.internal.inspect.ValidationProblemCollector;
import org.gradle.model.internal.type.ModelType;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

@ServiceScope(value={Scope.Global.class})
public class NamedObjectInstantiator
implements ManagedFactory {
    private static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{Named.class.getName()});
    private static final Type OBJECT = Type.getType(Object.class);
    private static final Type STRING = Type.getType(String.class);
    private static final Type CLASS_GENERATING_LOADER = Type.getType(ClassGeneratingLoader.class);
    private static final Type MANAGED = Type.getType(Managed.class);
    private static final String[] INTERFACES_FOR_ABSTRACT_CLASS = new String[]{MANAGED.getInternalName()};
    private static final String RETURN_VOID = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    private static final String RETURN_STRING = Type.getMethodDescriptor((Type)STRING, (Type[])new Type[0]);
    private static final String RETURN_CLASS = Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]);
    private static final String RETURN_BOOLEAN = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
    private static final String RETURN_OBJECT = Type.getMethodDescriptor((Type)OBJECT, (Type[])new Type[0]);
    private static final String RETURN_INT = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
    private static final String RETURN_VOID_FROM_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING});
    private static final String RETURN_OBJECT_FROM_STRING = Type.getMethodDescriptor((Type)OBJECT, (Type[])new Type[]{STRING});
    private static final String NAME_FIELD = "_gr_name_";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final Cache<Class<?>, LoadingCache<String, Object>> generatedTypes;
    private final String implSuffix;
    private final String factorySuffix;
    private final Function<Class<?>, LoadingCache<String, Object>> cacheFactoryFunction = this::cacheFactory;

    public NamedObjectInstantiator(ClassCacheFactory cacheFactory) {
        this.implSuffix = ClassGeneratorSuffixRegistry.assign((String)"$Impl");
        this.factorySuffix = ClassGeneratorSuffixRegistry.assign((String)(this.implSuffix + "Factory"));
        this.generatedTypes = cacheFactory.newClassMap();
    }

    @Override
    public int getId() {
        return FACTORY_ID;
    }

    @Override
    public <T> T fromState(Class<T> type, Object state) {
        return (T)(Named.class.isAssignableFrom(type) ? Cast.uncheckedCast(this.named((Class)Cast.uncheckedCast(type), (String)state)) : null);
    }

    public <T extends Named> T named(Class<T> type, String name) throws ObjectInstantiationException {
        try {
            return (T)((Named)type.cast(((LoadingCache)this.generatedTypes.get(type, this.cacheFactoryFunction)).getUnchecked((Object)name)));
        }
        catch (UncheckedExecutionException e) {
            throw new ObjectInstantiationException(type, e.getCause());
        }
        catch (Exception e) {
            throw new ObjectInstantiationException(type, (Throwable)e);
        }
    }

    private ClassGeneratingLoader loaderFor(Class<?> publicClass) {
        this.validate(publicClass);
        Type implementationType = this.generateImplementationClassFor(publicClass);
        Class<Object> factoryClass = this.generateFactoryClassFor(publicClass, implementationType);
        try {
            return (ClassGeneratingLoader)((Object)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void validate(Class<?> publicClass) {
        FormattingValidationProblemCollector problemCollector = new FormattingValidationProblemCollector("Named implementation class", ModelType.of(publicClass));
        this.visitFields(publicClass, problemCollector);
        if (problemCollector.hasProblems()) {
            throw new GradleException(problemCollector.format());
        }
    }

    private Type generateImplementationClassFor(Class<?> publicClass) {
        String[] interfaces;
        Type superClass;
        final Type publicType = Type.getType(publicClass);
        if (publicClass.isInterface()) {
            superClass = OBJECT;
            interfaces = new String[]{publicType.getInternalName(), MANAGED.getInternalName()};
        } else {
            superClass = publicType;
            interfaces = INTERFACES_FOR_ABSTRACT_CLASS;
        }
        final AsmClassGenerator generator = new AsmClassGenerator(publicClass, this.implSuffix);
        new ClassVisitorScope((ClassVisitor)generator.getVisitor()){
            {
                super(cv);
                final String generatedTypeName = generator.getGeneratedType().getInternalName();
                this.visit(49, 4097, generatedTypeName, null, superClass.getInternalName(), interfaces);
                this.addField(2, NamedObjectInstantiator.NAME_FIELD, STRING);
                this.publicMethod(NamedObjectInstantiator.CONSTRUCTOR_NAME, RETURN_VOID_FROM_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._ALOAD(0);
                        this._INVOKESPECIAL(superClass, NamedObjectInstantiator.CONSTRUCTOR_NAME, RETURN_VOID);
                        this._ALOAD(0);
                        this._ALOAD(1);
                        this._PUTFIELD(generatedTypeName, NamedObjectInstantiator.NAME_FIELD, STRING);
                        this._RETURN();
                    }
                });
                this.publicMethod("getName", RETURN_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._ALOAD(0);
                        this._GETFIELD(generatedTypeName, NamedObjectInstantiator.NAME_FIELD, STRING);
                        this._ARETURN();
                    }
                });
                this.publicMethod("toString", RETURN_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._ALOAD(0);
                        this._GETFIELD(generatedTypeName, NamedObjectInstantiator.NAME_FIELD, STRING);
                        this._ARETURN();
                    }
                });
                this.publicMethod("unpackState", RETURN_OBJECT, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._ALOAD(0);
                        this._GETFIELD(generatedTypeName, NamedObjectInstantiator.NAME_FIELD, STRING);
                        this._ARETURN();
                    }
                });
                this.publicMethod("publicType", RETURN_CLASS, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._LDC(publicType);
                        this._ARETURN();
                    }
                });
                this.publicMethod("isImmutable", RETURN_BOOLEAN, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        this._LDC(true);
                        this._IRETURN_OF(Type.BOOLEAN_TYPE);
                    }
                });
                this.publicMethod("getFactoryId", RETURN_INT, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        this._LDC(FACTORY_ID);
                        this._IRETURN();
                    }
                });
                this.visitEnd();
            }
        };
        generator.define();
        return generator.getGeneratedType();
    }

    private Class<Object> generateFactoryClassFor(Class<?> publicClass, final Type implementationType) {
        final AsmClassGenerator generator = new AsmClassGenerator(publicClass, this.factorySuffix);
        new ClassVisitorScope((ClassVisitor)generator.getVisitor()){
            {
                super(cv);
                this.visit(49, 4097, generator.getGeneratedType().getInternalName(), null, CLASS_GENERATING_LOADER.getInternalName(), null);
                this.publicMethod(NamedObjectInstantiator.CONSTRUCTOR_NAME, RETURN_VOID, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        this._ALOAD(0);
                        this._INVOKESPECIAL(CLASS_GENERATING_LOADER, NamedObjectInstantiator.CONSTRUCTOR_NAME, RETURN_VOID);
                        this._RETURN();
                    }
                });
                this.publicMethod("load", RETURN_OBJECT_FROM_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._NEW(implementationType);
                        this._DUP();
                        this._ALOAD(1);
                        this._INVOKESPECIAL(implementationType, NamedObjectInstantiator.CONSTRUCTOR_NAME, RETURN_VOID_FROM_STRING);
                        this._ARETURN();
                    }
                });
                this.visitEnd();
            }
        };
        return generator.define();
    }

    private void visitFields(Class<?> type, ValidationProblemCollector collector) {
        if (type.equals(Object.class)) {
            return;
        }
        if (type.getSuperclass() != null) {
            this.visitFields(type.getSuperclass(), collector);
        }
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || GroovyObject.class.isAssignableFrom(type) && field.getName().equals("metaClass")) continue;
            collector.add(field, "A Named implementation class must not define any instance fields.");
        }
    }

    private LoadingCache<String, Object> cacheFactory(Class<?> type) {
        return CacheBuilder.newBuilder().build((CacheLoader)this.loaderFor(type));
    }

    protected static abstract class ClassGeneratingLoader
    extends CacheLoader<String, Object> {
        protected ClassGeneratingLoader() {
        }

        public abstract Object load(String var1);
    }
}

