/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.hppc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.internal.hppc.AbstractIterator;
import org.apache.lucene.internal.hppc.BitMixer;
import org.apache.lucene.internal.hppc.BufferAllocationException;
import org.apache.lucene.internal.hppc.CharCursor;
import org.apache.lucene.internal.hppc.HashContainers;
import org.apache.lucene.internal.hppc.ObjectCursor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class CharObjectHashMap<VType>
implements Iterable<CharObjectCursor<VType>>,
Accountable,
Cloneable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CharObjectHashMap.class);
    private static final char EMPTY_KEY = '\u0000';
    public char[] keys;
    public Object[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public CharObjectHashMap() {
        this(4);
    }

    public CharObjectHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharObjectHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public CharObjectHashMap(CharObjectHashMap<VType> map) {
        this(map.size());
        this.putAll(map);
    }

    public VType put(char key, VType value) {
        char existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == '\u0000') {
            Object previousValue = this.hasEmptyKey ? this.values[mask + 1] : null;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return null;
    }

    public int putAll(Iterable<? extends CharObjectCursor<? extends VType>> iterable) {
        int count = this.size();
        for (CharObjectCursor<VType> charObjectCursor : iterable) {
            this.put(charObjectCursor.key, charObjectCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(char key, VType value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    public VType remove(char key) {
        char existing;
        int mask = this.mask;
        if (key == '\u0000') {
            if (!this.hasEmptyKey) {
                return null;
            }
            this.hasEmptyKey = false;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return (VType)previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public VType get(char key) {
        char existing;
        if (key == '\u0000') {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public VType getOrDefault(char key, VType defaultValue) {
        char existing;
        if (key == '\u0000') {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue);
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public boolean containsKey(char key) {
        char existing;
        if (key == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public int indexOf(char key) {
        char existing;
        int mask = this.mask;
        if (key == '\u0000') {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public VType indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return (VType)this.values[index];
    }

    public VType indexReplace(int index, VType newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index];
        this.values[index] = newValue;
        return (VType)previousValue;
    }

    public void indexInsert(int index, char key, VType value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == '\u0000') {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == '\u0000');
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    public VType indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index];
        if (index > this.mask) {
            assert (index == this.mask + 1);
            this.hasEmptyKey = false;
            this.values[index] = 0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return (VType)previousValue;
    }

    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (CharObjectCursor<VType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((CharObjectHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(CharObjectHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (CharObjectCursor<?> c : other) {
            char key = c.key;
            if (this.containsKey(key) && Objects.equals(c.value, this.get(key))) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            char[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<CharObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + this.sizeOfValues();
    }

    private long sizeOfValues() {
        long size = RamUsageEstimator.shallowSizeOf(this.values);
        for (ObjectCursor value : this.values()) {
            size += RamUsageEstimator.sizeOfObject(value);
        }
        return size;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    public ValuesContainer values() {
        return new ValuesContainer();
    }

    public CharObjectHashMap<VType> clone() {
        try {
            CharObjectHashMap cloned = (CharObjectHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <VType> CharObjectHashMap<VType> from(char[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharObjectHashMap<VType> map = new CharObjectHashMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(char key) {
        assert (key != '\u0000');
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(char[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        char[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            char existing = fromKeys[from];
            if (existing == '\u0000') continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        char[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new char[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, char pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == '\u0000' && pendingKey != '\u0000');
        char[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        char existing;
        char[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != '\u0000') {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        values[gapSlot] = null;
        --this.assigned;
    }

    public static final class CharObjectCursor<VType> {
        public int index;
        public char key;
        public VType value;

        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + String.valueOf(this.value) + "]";
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = CharObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharObjectHashMap.this.mask;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int mask = CharObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (CharObjectHashMap.this.keys[this.slot] == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = CharObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = CharObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    public final class ValuesContainer
    implements Iterable<ObjectCursor<VType>> {
        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        public int size() {
            return CharObjectHashMap.this.size();
        }

        public VType[] toArray() {
            Object[] array = new Object[this.size()];
            int i = 0;
            for (ObjectCursor cursor : this) {
                array[i++] = cursor.value;
            }
            return array;
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = CharObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharObjectHashMap.this.mask;
        }

        @Override
        protected CharCursor fetch() {
            int mask = CharObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharObjectHashMap.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = '\u0000';
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    public final class KeysContainer
    implements Iterable<CharCursor> {
        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        public int size() {
            return CharObjectHashMap.this.size();
        }

        public char[] toArray() {
            char[] array = new char[this.size()];
            int i = 0;
            for (CharCursor cursor : this) {
                array[i++] = cursor.value;
            }
            return array;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<CharObjectCursor<VType>> {
        private final CharObjectCursor<VType> cursor = new CharObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = CharObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharObjectHashMap.this.mask;
        }

        @Override
        protected CharObjectCursor<VType> fetch() {
            int mask = CharObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharObjectHashMap.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = CharObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = '\u0000';
                this.cursor.value = CharObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (CharObjectCursor)this.done();
        }
    }
}

