/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.apache.commons.codec.binary.Base32;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.digest.CompositeDigester;
import org.apache.tika.parser.digest.InputStreamDigester;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class BouncyCastleDigester
extends CompositeDigester {
    public BouncyCastleDigester(int markLimit, String algorithmString) {
        super(BouncyCastleDigester.buildDigesters(markLimit, algorithmString));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DigestingParser.Digester[] buildDigesters(int markLimit, String digesterDef) {
        String[] digests = digesterDef.split(",");
        DigestingParser.Digester[] digesters = new DigestingParser.Digester[digests.length];
        int i = 0;
        for (String digest : digests) {
            void var10_10;
            String[] parts = digest.split(":");
            Object var10_11 = null;
            if (parts.length > 1) {
                if (parts[1].equals("16")) {
                    HexEncoder hexEncoder = new HexEncoder();
                } else {
                    if (!parts[1].equals("32")) throw new IllegalArgumentException("Value must be '16' or '32'");
                    Base32Encoder base32Encoder = new Base32Encoder();
                }
            } else {
                HexEncoder hexEncoder = new HexEncoder();
            }
            digesters[i++] = new BCInputStreamDigester(markLimit, parts[0], (DigestingParser.Encoder)var10_10);
        }
        return digesters;
    }

    private static class BCInputStreamDigester
    extends InputStreamDigester {
        public BCInputStreamDigester(int markLimit, String algorithm, DigestingParser.Encoder encoder) {
            super(markLimit, algorithm, encoder);
            try {
                MessageDigest.getInstance(algorithm, this.getProvider());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }

        protected Provider getProvider() {
            return new BouncyCastleProvider();
        }
    }

    private static class Base32Encoder
    implements DigestingParser.Encoder {
        private Base32Encoder() {
        }

        public String encode(byte[] bytes) {
            return new Base32().encodeToString(bytes);
        }
    }

    private static class HexEncoder
    implements DigestingParser.Encoder {
        private HexEncoder() {
        }

        public String encode(byte[] bytes) {
            return Hex.toHexString((byte[])bytes);
        }
    }
}

