/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.bridge.DocumentLoader;
import io.sf.carte.echosvg.bridge.URIResolver;
import io.sf.carte.echosvg.dom.AbstractNode;
import io.sf.carte.echosvg.dom.xbl.NodeXBL;
import io.sf.carte.echosvg.dom.xbl.XBLShadowTreeElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

public class SVG12URIResolver
extends URIResolver {
    public SVG12URIResolver(SVGDocument doc, DocumentLoader dl) {
        super(doc, dl);
    }

    @Override
    protected String getRefererBaseURI(Element ref) {
        AbstractNode aref = (AbstractNode)ref;
        if (aref.getXblBoundElement() != null) {
            return null;
        }
        return aref.getBaseURI();
    }

    @Override
    protected Node getNodeByFragment(String frag, Element ref) {
        NodeXBL refx = (NodeXBL)ref;
        NodeXBL boundElt = (NodeXBL)refx.getXblBoundElement();
        if (boundElt != null) {
            XBLShadowTreeElement shadow = (XBLShadowTreeElement)boundElt.getXblShadowTree();
            Element n = shadow.getElementById(frag);
            if (n != null) {
                return n;
            }
            NodeList nl = refx.getXblDefinitions();
            for (int i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i).getOwnerDocument().getElementById(frag);
                if (n == null) continue;
                return n;
            }
        }
        return super.getNodeByFragment(frag, ref);
    }
}

