/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CommentStore;
import io.sf.carte.doc.style.css.parser.LexicalProvider;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;

class DefaultCommentStore
implements CommentStore {
    private final LexicalProvider parent;
    StringList precedingComments = null;
    StringList trailingComments = null;

    public DefaultCommentStore(LexicalProvider parent) {
        this.parent = parent;
    }

    @Override
    public void addPrecedingComment(String comment) {
        if (this.precedingComments == null) {
            this.precedingComments = new LinkedStringList();
        }
        this.precedingComments.add(comment);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setPrecedingComments(LexicalUnitImpl lu) {
        if (this.precedingComments != null) {
            LexicalUnitImpl currentlu;
            if (!lu.addPrecedingComments(this.precedingComments) && (currentlu = this.parent.getCurrentLexicalUnit()) != null) {
                LexicalUnitImpl plu = lu.previousLexicalUnit;
                if (plu == null) {
                    if (this.parent.isFunctionOrExpressionContext()) {
                        plu = currentlu.parameters;
                        if (plu == null) {
                            this.precedingComments = null;
                            return;
                        }
                        plu = CSSParser.findLastValue(plu);
                    } else {
                        plu = currentlu;
                    }
                }
                plu.addTrailingComments(this.precedingComments);
            }
            this.precedingComments = null;
        }
    }

    @Override
    public void addTrailingComment(String comment) {
        if (this.trailingComments == null) {
            this.trailingComments = new LinkedStringList();
        }
        this.trailingComments.add(comment);
    }

    @Override
    public void setTrailingComments() {
        LexicalUnitImpl currentlu = this.parent.getCurrentLexicalUnit();
        if (currentlu != null) {
            LexicalUnitImpl lu = currentlu;
            if (this.parent.isFunctionOrExpressionContext()) {
                if (lu.parameters != null) {
                    lu = CSSParser.findLastValue(lu.parameters);
                } else {
                    return;
                }
            }
            this.setTrailingComments(lu);
        }
    }

    @Override
    public void setTrailingComments(LexicalUnitImpl lu) {
        if (this.trailingComments != null) {
            if (this.precedingComments != null) {
                this.trailingComments.addAll(this.precedingComments);
                this.precedingComments = null;
            }
            if (!lu.addTrailingComments(this.trailingComments)) {
                if (this.precedingComments != null) {
                    this.precedingComments.addAll(this.trailingComments);
                } else {
                    this.precedingComments = this.trailingComments;
                }
            }
            this.trailingComments = null;
        } else if (this.precedingComments != null) {
            lu.addTrailingComments(this.precedingComments);
            this.precedingComments = null;
        }
    }

    @Override
    public void setLastParameterTrailingComments(LexicalUnitImpl param) {
        if (this.trailingComments != null) {
            LexicalUnitImpl lu;
            if (this.precedingComments != null) {
                this.trailingComments.addAll(this.precedingComments);
                this.precedingComments = null;
            }
            if (!(lu = CSSParser.findLastValue(param)).addTrailingComments(this.trailingComments)) {
                if (this.precedingComments != null) {
                    this.precedingComments.addAll(this.trailingComments);
                } else {
                    this.precedingComments = this.trailingComments;
                }
            }
            this.trailingComments = null;
        } else if (this.precedingComments != null) {
            LexicalUnitImpl lu = CSSParser.findLastValue(param);
            lu.addTrailingComments(this.precedingComments);
            this.precedingComments = null;
        }
    }

    @Override
    public boolean haveTrailingComments() {
        if (this.trailingComments == null) {
            LexicalUnitImpl lu = this.parent.getCurrentLexicalUnit();
            if (lu == null) {
                return false;
            }
            if (this.parent.isFunctionOrExpressionContext() && lu.parameters != null) {
                lu = CSSParser.findLastValue(lu.parameters);
            }
            return lu.getTrailingComments() != null;
        }
        return true;
    }

    @Override
    public StringList getPrecedingCommentsAndClear() {
        StringList ret = this.precedingComments;
        this.precedingComments = null;
        return ret;
    }

    @Override
    public StringList getTrailingCommentsAndClear() {
        StringList ret = this.trailingComments;
        this.trailingComments = null;
        return ret;
    }

    @Override
    public void set(LexicalProvider caller) {
        this.precedingComments = caller.getPrecedingCommentsAndClear();
        this.trailingComments = caller.getTrailingCommentsAndClear();
    }

    @Override
    public void resetTrailingComments() {
        this.trailingComments = null;
    }

    @Override
    public void reset() {
        this.precedingComments = null;
        this.trailingComments = null;
    }
}

