/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class JNIHandleBlock
extends VMObject {
    private static Field handlesField;
    private static CIntegerField topField;
    private static AddressField nextField;
    private static int blockSizeInOops;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JNIHandleBlock");
        handlesField = type.getField("_handles");
        topField = type.getCIntegerField("_top");
        nextField = type.getAddressField("_next");
        blockSizeInOops = db.lookupIntConstant("JNIHandleBlock::block_size_in_oops");
    }

    public JNIHandleBlock(Address addr) {
        super(addr);
    }

    public JNIHandleBlock next() {
        Address handleAddr = nextField.getValue(this.addr);
        if (handleAddr == null) {
            return null;
        }
        if (this.top() < blockSizeInOops) {
            return null;
        }
        return new JNIHandleBlock(handleAddr);
    }

    public int top() {
        return (int)topField.getValue(this.addr);
    }

    public void oopsDo(AddressVisitor visitor) {
        for (int i = 0; i < this.top(); ++i) {
            Address cur = this.getOopHandleAddress(i);
            if (cur == null) continue;
            visitor.visitAddress(cur);
        }
        JNIHandleBlock n = this.next();
        if (n != null) {
            n.oopsDo(visitor);
        }
    }

    public OopHandle getOopHandle(int x) {
        Address oopAddr = this.getOopHandleAddress(x);
        if (oopAddr != null) {
            return oopAddr.getOopHandleAt(0L);
        }
        return null;
    }

    public JNIHandleBlock blockContainingHandle(Address jniHandle) {
        for (JNIHandleBlock cur = this; cur != null; cur = cur.next()) {
            if (this.indexOfHandle(jniHandle) < 0) continue;
            return cur;
        }
        return null;
    }

    public int indexOfHandle(Address jniHandle) {
        for (int i = 0; i < this.top(); ++i) {
            Address addr = this.getOopHandleAddress(i);
            if (addr == null || !addr.equals(jniHandle)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        Address handleBase = this.addr.addOffsetTo(handlesField.getOffset());
        Address handleEnd = this.addr.addOffsetTo(handlesField.getOffset() + (long)this.top() * VM.getVM().getOopSize());
        return "JNIHandleBlock [" + handleBase + ", " + handleEnd + ")";
    }

    private Address getOopHandleAddress(int x) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(x < this.top(), "out of bounds");
        }
        Address oopAddr = this.addr.addOffsetTo(handlesField.getOffset() + (long)x * VM.getVM().getOopSize());
        OopHandle handle = oopAddr.getOopHandleAt(0L);
        if (VM.getVM().getUniverse().isInReserved(handle) && !VM.getVM().getJNIHandles().isDeletedHandle(handle)) {
            return oopAddr;
        }
        return null;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JNIHandleBlock.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

