/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StoreBuilderWrapper;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;

public class StreamsBuilder {
    protected final Topology topology;
    protected final InternalTopologyBuilder internalTopologyBuilder;
    protected final InternalStreamsBuilder internalStreamsBuilder;

    public StreamsBuilder() {
        this.topology = new Topology();
        this.internalTopologyBuilder = this.topology.internalTopologyBuilder;
        this.internalStreamsBuilder = new InternalStreamsBuilder(this.internalTopologyBuilder, false);
    }

    public StreamsBuilder(TopologyConfig topologyConfigs) {
        this.topology = this.newTopology(topologyConfigs);
        this.internalTopologyBuilder = this.topology.internalTopologyBuilder;
        this.internalStreamsBuilder = new InternalStreamsBuilder(this.internalTopologyBuilder, TopologyConfig.InternalConfig.getBoolean(topologyConfigs.originals(), "__enable.process.processValue.fix__", false));
    }

    protected Topology newTopology(TopologyConfig topologyConfigs) {
        return new Topology(topologyConfigs);
    }

    public synchronized <K, V> KStream<K, V> stream(String topic) {
        return this.stream(Collections.singleton(topic));
    }

    public synchronized <K, V> KStream<K, V> stream(String topic, Consumed<K, V> consumed) {
        return this.stream(Collections.singleton(topic), consumed);
    }

    public synchronized <K, V> KStream<K, V> stream(Collection<String> topics) {
        return this.stream(topics, Consumed.with(null, null));
    }

    public synchronized <K, V> KStream<K, V> stream(Collection<String> topics, Consumed<K, V> consumed) {
        Objects.requireNonNull(topics, "topics can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        return this.internalStreamsBuilder.stream(topics, new ConsumedInternal<K, V>(consumed));
    }

    public synchronized <K, V> KStream<K, V> stream(Pattern topicPattern) {
        return this.stream(topicPattern, Consumed.with(null, null));
    }

    public synchronized <K, V> KStream<K, V> stream(Pattern topicPattern, Consumed<K, V> consumed) {
        Objects.requireNonNull(topicPattern, "topicPattern can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        return this.internalStreamsBuilder.stream(topicPattern, new ConsumedInternal<K, V>(consumed));
    }

    public synchronized <K, V> KTable<K, V> table(String topic, Consumed<K, V> consumed, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        ConsumedInternal<K, V> consumedInternal = new ConsumedInternal<K, V>(consumed);
        materialized.withKeySerde(consumedInternal.keySerde()).withValueSerde(consumedInternal.valueSerde());
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.internalStreamsBuilder, topic + "-");
        return this.internalStreamsBuilder.table(topic, consumedInternal, materializedInternal);
    }

    public synchronized <K, V> KTable<K, V> table(String topic) {
        return this.table(topic, Consumed.with(null, null));
    }

    public synchronized <K, V> KTable<K, V> table(String topic, Consumed<K, V> consumed) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        ConsumedInternal<K, V> consumedInternal = new ConsumedInternal<K, V>(consumed);
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.with(consumedInternal.keySerde(), consumedInternal.valueSerde()), this.internalStreamsBuilder, topic + "-");
        return this.internalStreamsBuilder.table(topic, consumedInternal, materializedInternal);
    }

    public synchronized <K, V> KTable<K, V> table(String topic, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.internalStreamsBuilder, topic + "-");
        ConsumedInternal<K, V> consumedInternal = new ConsumedInternal<K, V>(Consumed.with(materializedInternal.keySerde(), materializedInternal.valueSerde()));
        return this.internalStreamsBuilder.table(topic, consumedInternal, materializedInternal);
    }

    public synchronized <K, V> GlobalKTable<K, V> globalTable(String topic, Consumed<K, V> consumed) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        ConsumedInternal<K, V> consumedInternal = new ConsumedInternal<K, V>(consumed);
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.with(consumedInternal.keySerde(), consumedInternal.valueSerde()).withLoggingDisabled(), this.internalStreamsBuilder, topic + "-", true);
        return this.internalStreamsBuilder.globalTable(topic, consumedInternal, materializedInternal);
    }

    public synchronized <K, V> GlobalKTable<K, V> globalTable(String topic) {
        return this.globalTable(topic, Consumed.with(null, null));
    }

    public synchronized <K, V> GlobalKTable<K, V> globalTable(String topic, Consumed<K, V> consumed, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        ConsumedInternal<K, V> consumedInternal = new ConsumedInternal<K, V>(consumed);
        materialized.withKeySerde(consumedInternal.keySerde()).withValueSerde(consumedInternal.valueSerde()).withLoggingDisabled();
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.internalStreamsBuilder, topic + "-");
        return this.internalStreamsBuilder.globalTable(topic, consumedInternal, materializedInternal);
    }

    public synchronized <K, V> GlobalKTable<K, V> globalTable(String topic, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.internalStreamsBuilder, topic + "-");
        return this.internalStreamsBuilder.globalTable(topic, new ConsumedInternal<K, V>(Consumed.with(materializedInternal.keySerde(), materializedInternal.valueSerde())), materializedInternal);
    }

    public synchronized StreamsBuilder addStateStore(StoreBuilder<?> builder) {
        Objects.requireNonNull(builder, "builder can't be null");
        this.internalStreamsBuilder.addStateStore(StoreBuilderWrapper.wrapStoreBuilder(builder));
        return this;
    }

    public synchronized <KIn, VIn> StreamsBuilder addGlobalStore(StoreBuilder<?> storeBuilder, String topic, Consumed<KIn, VIn> consumed, ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier) {
        Objects.requireNonNull(storeBuilder, "storeBuilder can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        this.internalStreamsBuilder.addGlobalStore(StoreBuilderWrapper.wrapStoreBuilder(storeBuilder), topic, new ConsumedInternal<KIn, VIn>(consumed), stateUpdateSupplier, true);
        return this;
    }

    public synchronized Topology build() {
        return this.build(null);
    }

    public synchronized Topology build(Properties props) {
        this.internalStreamsBuilder.buildAndOptimizeTopology(props);
        return this.topology;
    }
}

