/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.raft.ControlRecord;

public final class Batch<T>
implements Iterable<T> {
    private final long baseOffset;
    private final int epoch;
    private final long appendTimestamp;
    private final int sizeInBytes;
    private final long lastOffset;
    private final List<T> records;
    private final List<ControlRecord> controlRecords;

    private Batch(long baseOffset, int epoch, long appendTimestamp, int sizeInBytes, long lastOffset, List<T> records, List<ControlRecord> controlRecords) {
        this.baseOffset = baseOffset;
        this.epoch = epoch;
        this.appendTimestamp = appendTimestamp;
        this.sizeInBytes = sizeInBytes;
        this.lastOffset = lastOffset;
        this.records = records;
        this.controlRecords = controlRecords;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public long appendTimestamp() {
        return this.appendTimestamp;
    }

    public List<T> records() {
        return this.records;
    }

    public List<ControlRecord> controlRecords() {
        return this.controlRecords;
    }

    public int epoch() {
        return this.epoch;
    }

    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public Iterator<T> iterator() {
        return this.records.iterator();
    }

    public String toString() {
        return "Batch(baseOffset=" + this.baseOffset + ", epoch=" + this.epoch + ", appendTimestamp=" + this.appendTimestamp + ", sizeInBytes=" + this.sizeInBytes + ", lastOffset=" + this.lastOffset + ", records=" + String.valueOf(this.records) + ", controlRecords=" + String.valueOf(this.controlRecords) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Batch batch = (Batch)o;
        return this.baseOffset == batch.baseOffset && this.epoch == batch.epoch && this.appendTimestamp == batch.appendTimestamp && this.sizeInBytes == batch.sizeInBytes && this.lastOffset == batch.lastOffset && Objects.equals(this.records, batch.records) && Objects.equals(this.controlRecords, batch.controlRecords);
    }

    public int hashCode() {
        return Objects.hash(this.baseOffset, this.epoch, this.appendTimestamp, this.sizeInBytes, this.lastOffset, this.records, this.controlRecords);
    }

    public static <T> Batch<T> control(long baseOffset, int epoch, long appendTimestamp, int sizeInBytes, List<ControlRecord> records) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException(String.format("Control batch must contain at least one record; baseOffset = %d; epoch = %d", baseOffset, epoch));
        }
        return new Batch(baseOffset, epoch, appendTimestamp, sizeInBytes, baseOffset + (long)records.size() - 1L, List.of(), records);
    }

    public static <T> Batch<T> data(long baseOffset, int epoch, long appendTimestamp, int sizeInBytes, List<T> records) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException(String.format("Batch must contain at least one record; baseOffset = %d; epoch = %d", baseOffset, epoch));
        }
        return new Batch<T>(baseOffset, epoch, appendTimestamp, sizeInBytes, baseOffset + (long)records.size() - 1L, records, List.of());
    }
}

