/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.osmand.Location;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.data.LatLon;
import net.osmand.data.LocationPoint;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.routing.AlarmInfo;
import net.osmand.plus.routing.RouteCalculationParams;
import net.osmand.plus.routing.RouteDirectionInfo;
import net.osmand.plus.routing.RoutingHelper;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.TurnType;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;

public class RouteCalculationResult {
    private static double distanceClosestToIntermediate = 400.0;
    private final List<Location> locations;
    private final List<RouteDirectionInfo> directions;
    private final List<RouteSegmentResult> segments;
    private final List<AlarmInfo> alarmInfo;
    private final String errorMessage;
    private final int[] listDistance;
    private final int[] intermediatePoints;
    private final float routingTime;
    protected int cacheCurrentTextDirectionInfo = -1;
    protected List<RouteDirectionInfo> cacheAgreggatedDirections;
    protected List<LocationPoint> locationPoints = new ArrayList<LocationPoint>();
    protected int currentDirectionInfo = 0;
    protected int currentRoute = 0;
    protected int nextIntermediate = 0;
    protected int currentWaypointGPX = 0;
    protected int lastWaypointGPX = 0;

    public RouteCalculationResult(String errorMessage) {
        this.errorMessage = errorMessage;
        this.routingTime = 0.0f;
        this.intermediatePoints = new int[0];
        this.locations = new ArrayList<Location>();
        this.segments = new ArrayList<RouteSegmentResult>();
        this.listDistance = new int[0];
        this.directions = new ArrayList<RouteDirectionInfo>();
        this.alarmInfo = new ArrayList<AlarmInfo>();
    }

    public RouteCalculationResult(List<Location> list, List<RouteDirectionInfo> directions, RouteCalculationParams params, List<LocationPoint> waypoints) {
        boolean addMissingTurns;
        ArrayList<RouteDirectionInfo> localDirections;
        this.routingTime = 0.0f;
        this.errorMessage = null;
        this.intermediatePoints = new int[params.intermediates == null ? 0 : params.intermediates.size()];
        ArrayList<Location> locations = list == null ? new ArrayList<Location>() : new ArrayList<Location>(list);
        ArrayList<RouteDirectionInfo> arrayList = localDirections = directions == null ? new ArrayList<RouteDirectionInfo>() : new ArrayList<RouteDirectionInfo>(directions);
        if (!locations.isEmpty()) {
            this.checkForDuplicatePoints(locations, localDirections);
        }
        if (waypoints != null) {
            this.locationPoints.addAll(waypoints);
        }
        if (addMissingTurns = true) {
            this.removeUnnecessaryGoAhead(localDirections);
            RouteCalculationResult.addMissingTurnsToRoute(locations, localDirections, params.start, params.end, params.mode, params.ctx, params.leftSide);
            RouteCalculationResult.introduceFirstPointAndLastPoint(locations, localDirections, null, params.start, params.end);
        }
        this.locations = Collections.unmodifiableList(locations);
        this.segments = new ArrayList<RouteSegmentResult>();
        this.listDistance = new int[locations.size()];
        RouteCalculationResult.updateListDistanceTime(this.listDistance, this.locations);
        this.alarmInfo = new ArrayList<AlarmInfo>();
        RouteCalculationResult.calculateIntermediateIndexes(params.ctx, this.locations, params.intermediates, localDirections, this.intermediatePoints);
        this.directions = Collections.unmodifiableList(localDirections);
        RouteCalculationResult.updateDirectionsTime(this.directions, this.listDistance);
    }

    public RouteCalculationResult(List<RouteSegmentResult> list, Location start, LatLon end, List<LatLon> intermediates, OsmWindow ctx, boolean leftSide, float routingTime, List<LocationPoint> waypoints) {
        this.routingTime = routingTime;
        if (waypoints != null) {
            this.locationPoints.addAll(waypoints);
        }
        ArrayList<RouteDirectionInfo> computeDirections = new ArrayList<RouteDirectionInfo>();
        this.errorMessage = null;
        this.intermediatePoints = new int[intermediates == null ? 0 : intermediates.size()];
        ArrayList<Location> locations = new ArrayList<Location>();
        ArrayList<AlarmInfo> alarms = new ArrayList<AlarmInfo>();
        List<RouteSegmentResult> segments = RouteCalculationResult.convertVectorResult(computeDirections, locations, list, alarms, ctx);
        RouteCalculationResult.introduceFirstPointAndLastPoint(locations, computeDirections, segments, start, end);
        this.locations = Collections.unmodifiableList(locations);
        this.segments = Collections.unmodifiableList(segments);
        this.listDistance = new int[locations.size()];
        RouteCalculationResult.calculateIntermediateIndexes(ctx, this.locations, intermediates, computeDirections, this.intermediatePoints);
        RouteCalculationResult.updateListDistanceTime(this.listDistance, this.locations);
        this.directions = Collections.unmodifiableList(computeDirections);
        RouteCalculationResult.updateDirectionsTime(this.directions, this.listDistance);
        this.alarmInfo = Collections.unmodifiableList(alarms);
    }

    public List<LocationPoint> getLocationPoints() {
        return this.locationPoints;
    }

    public List<AlarmInfo> getAlarmInfo() {
        return this.alarmInfo;
    }

    private static void calculateIntermediateIndexes(OsmWindow ctx, List<Location> locations, List<LatLon> intermediates, List<RouteDirectionInfo> localDirections, int[] intermediatePoints) {
        if (intermediates != null && localDirections != null) {
            int[] interLocations = new int[intermediates.size()];
            int currentIntermediate = 0;
            double distanceThreshold = 25.0;
            double prevDistance = distanceThreshold * 4.0;
            for (int currentLocation = 0; (currentIntermediate < intermediates.size() || prevDistance > distanceThreshold) && currentLocation < locations.size(); ++currentLocation) {
                if (currentIntermediate < intermediates.size() && RouteCalculationResult.getDistanceToLocation(locations, intermediates.get(currentIntermediate), currentLocation) < distanceClosestToIntermediate) {
                    prevDistance = RouteCalculationResult.getDistanceToLocation(locations, intermediates.get(currentIntermediate), currentLocation);
                    interLocations[currentIntermediate] = currentLocation;
                    ++currentIntermediate;
                    continue;
                }
                if (currentIntermediate <= 0 || !(prevDistance > distanceThreshold) || !(RouteCalculationResult.getDistanceToLocation(locations, intermediates.get(currentIntermediate - 1), currentLocation) < prevDistance)) continue;
                prevDistance = RouteCalculationResult.getDistanceToLocation(locations, intermediates.get(currentIntermediate - 1), currentLocation);
                interLocations[currentIntermediate - 1] = currentLocation;
            }
            currentIntermediate = 0;
            for (int currentDirection = 0; currentIntermediate < intermediates.size() && currentDirection < localDirections.size(); ++currentDirection) {
                int locationIndex = localDirections.get((int)currentDirection).routePointOffset;
                if (locationIndex < interLocations[currentIntermediate]) continue;
                if (locationIndex > interLocations[currentIntermediate] && RouteCalculationResult.getDistanceToLocation(locations, intermediates.get(currentIntermediate), locationIndex) > 50.0) {
                    RouteDirectionInfo toSplit = localDirections.get(currentDirection);
                    RouteDirectionInfo info = new RouteDirectionInfo(localDirections.get(currentDirection).getAverageSpeed(), TurnType.straight());
                    info.setRef(toSplit.getRef());
                    info.setStreetName(toSplit.getStreetName());
                    info.setDestinationName(toSplit.getDestinationName());
                    info.routePointOffset = interLocations[currentIntermediate];
                    info.setDescriptionRoute(ctx.getString(694));
                    localDirections.add(currentDirection, info);
                }
                intermediatePoints[currentIntermediate] = currentDirection;
                ++currentIntermediate;
            }
        }
    }

    private static double getDistanceToLocation(List<Location> locations, LatLon p, int currentLocation) {
        return MapUtils.getDistance(p, locations.get(currentLocation).getLatitude(), locations.get(currentLocation).getLongitude());
    }

    private static void attachAlarmInfo(List<AlarmInfo> alarms, RouteSegmentResult res, int intId, int locInd) {
        int[] pointTypes = res.getObject().getPointTypes(intId);
        if (pointTypes != null) {
            BinaryMapRouteReaderAdapter.RouteRegion reg = res.getObject().region;
            for (int r = 0; r < pointTypes.length; ++r) {
                BinaryMapRouteReaderAdapter.RouteTypeRule typeRule = reg.quickGetEncodingRule(pointTypes[r]);
                int x31 = res.getObject().getPoint31XTile(intId);
                int y31 = res.getObject().getPoint31YTile(intId);
                Location loc = new Location("");
                loc.setLatitude(MapUtils.get31LatitudeY(y31));
                loc.setLongitude(MapUtils.get31LongitudeX(x31));
                AlarmInfo info = AlarmInfo.createAlarmInfo(typeRule, locInd, loc);
                if (info == null) continue;
                alarms.add(info);
            }
        }
    }

    public List<RouteSegmentResult> getOriginalRoute() {
        if (this.segments.size() == 0) {
            return null;
        }
        ArrayList<RouteSegmentResult> list = new ArrayList<RouteSegmentResult>();
        list.add(this.segments.get(0));
        for (int i = 1; i < this.segments.size(); ++i) {
            if (this.segments.get(i - 1) == this.segments.get(i)) continue;
            list.add(this.segments.get(i));
        }
        return list;
    }

    private static List<RouteSegmentResult> convertVectorResult(List<RouteDirectionInfo> directions, List<Location> locations, List<RouteSegmentResult> list, List<AlarmInfo> alarms, OsmWindow ctx) {
        float prevDirectionTime = 0.0f;
        float prevDirectionDistance = 0.0f;
        ArrayList<RouteSegmentResult> segmentsToPopulate = new ArrayList<RouteSegmentResult>();
        for (int routeInd = 0; routeInd < list.size(); ++routeInd) {
            RouteSegmentResult s = list.get(routeInd);
            boolean plus = s.getStartPointIndex() < s.getEndPointIndex();
            int i = s.getStartPointIndex();
            int prevLocationSize = locations.size();
            while (true) {
                Location n = new Location("");
                LatLon point = s.getPoint(i);
                n.setLatitude(point.getLatitude());
                n.setLongitude(point.getLongitude());
                if (i == s.getEndPointIndex() && routeInd != list.size() - 1) break;
                locations.add(n);
                RouteCalculationResult.attachAlarmInfo(alarms, s, i, locations.size());
                segmentsToPopulate.add(s);
                if (i == s.getEndPointIndex()) break;
                if (plus) {
                    ++i;
                    continue;
                }
                --i;
            }
            TurnType turn = s.getTurnType();
            if (turn != null) {
                RouteDirectionInfo info = new RouteDirectionInfo(s.getSegmentSpeed(), turn);
                if (routeInd < list.size()) {
                    int lind;
                    if (turn.isRoundAbout()) {
                        int roundAboutEnd = prevLocationSize;
                        for (lind = routeInd; lind < list.size() - 1 && list.get(lind).getObject().roundabout(); ++lind) {
                            ++roundAboutEnd;
                        }
                        info.routeEndPointOffset = roundAboutEnd;
                    }
                    RouteSegmentResult next = list.get(lind);
                    info.setRef(next.getObject().getRef());
                    info.setStreetName(next.getObject().getName(ctx.getSettings().MAP_PREFERRED_LOCALE.get()));
                    info.setDestinationName(next.getObject().getDestinationName(ctx.getSettings().MAP_PREFERRED_LOCALE.get()));
                }
                String description = RouteCalculationResult.toString(turn, ctx) + " " + RoutingHelper.formatStreetName(info.getStreetName(), info.getRef(), info.getDestinationName());
                String[] pointNames = s.getObject().getPointNames(s.getStartPointIndex());
                if (pointNames != null) {
                    for (int t = 0; t < pointNames.length; ++t) {
                        description = description + " " + pointNames[t];
                    }
                }
                info.setDescriptionRoute(description);
                info.routePointOffset = prevLocationSize;
                if (directions.size() > 0 && prevDirectionTime > 0.0f && prevDirectionDistance > 0.0f) {
                    RouteDirectionInfo prev = directions.get(directions.size() - 1);
                    prev.setAverageSpeed(prevDirectionDistance / prevDirectionTime);
                    prevDirectionDistance = 0.0f;
                    prevDirectionTime = 0.0f;
                }
                directions.add(info);
            }
            prevDirectionDistance += s.getDistance();
            prevDirectionTime += s.getSegmentTime();
        }
        if (directions.size() > 0 && prevDirectionTime > 0.0f && prevDirectionDistance > 0.0f) {
            RouteDirectionInfo prev = directions.get(directions.size() - 1);
            prev.setAverageSpeed(prevDirectionDistance / prevDirectionTime);
        }
        return segmentsToPopulate;
    }

    protected static void addMissingTurnsToRoute(List<Location> locations, List<RouteDirectionInfo> originalDirections, Location start, LatLon end, ApplicationMode mode, OsmWindow ctx, boolean leftSide) {
        if (locations.isEmpty()) {
            return;
        }
        float speed = mode.getDefaultSpeed();
        int minDistanceForTurn = mode.getMinDistanceForTurn();
        ArrayList<RouteDirectionInfo> computeDirections = new ArrayList<RouteDirectionInfo>();
        int[] listDistance = new int[locations.size()];
        listDistance[locations.size() - 1] = 0;
        for (int i = locations.size() - 1; i > 0; --i) {
            listDistance[i - 1] = (int)locations.get(i - 1).distanceTo(locations.get(i));
            int n = i - 1;
            listDistance[n] = listDistance[n] + listDistance[i];
        }
        int previousLocation = 0;
        int prevBearingLocation = 0;
        RouteDirectionInfo previousInfo = new RouteDirectionInfo(speed, TurnType.straight());
        previousInfo.routePointOffset = 0;
        previousInfo.setDescriptionRoute(ctx.getString(694));
        computeDirections.add(previousInfo);
        int distForTurn = 0;
        float previousBearing = 0.0f;
        int startTurnPoint = 0;
        for (int i = 1; i < locations.size() - 1; ++i) {
            float delta;
            Location next = locations.get(i + 1);
            Location current = locations.get(i);
            float bearing = current.bearingTo(next);
            while (prevBearingLocation < i - 1 && locations.get(prevBearingLocation + 1).distanceTo(current) > 70.0f) {
                ++prevBearingLocation;
            }
            if (distForTurn == 0) {
                previousBearing = locations.get(prevBearingLocation).bearingTo(current);
                startTurnPoint = i;
            }
            TurnType type = null;
            String description = null;
            for (delta = previousBearing - bearing; delta < 0.0f; delta += 360.0f) {
            }
            while (delta > 360.0f) {
                delta -= 360.0f;
            }
            distForTurn = (int)((float)distForTurn + locations.get(i).distanceTo(locations.get(i + 1)));
            if (i < locations.size() - 1 && distForTurn < minDistanceForTurn) continue;
            if (delta > 45.0f && delta < 315.0f) {
                if (delta < 60.0f) {
                    type = TurnType.valueOf(3, leftSide);
                    description = ctx.getString(692);
                } else if (delta < 120.0f) {
                    type = TurnType.valueOf(2, leftSide);
                    description = ctx.getString(690);
                } else if (delta < 150.0f) {
                    type = TurnType.valueOf(4, leftSide);
                    description = ctx.getString(691);
                } else if (delta < 210.0f) {
                    type = TurnType.valueOf(10, leftSide);
                    description = ctx.getString(693);
                } else if (delta < 240.0f) {
                    description = ctx.getString(688);
                    type = TurnType.valueOf(7, leftSide);
                } else if (delta < 300.0f) {
                    description = ctx.getString(687);
                    type = TurnType.valueOf(5, leftSide);
                } else {
                    description = ctx.getString(689);
                    type = TurnType.valueOf(6, leftSide);
                }
                previousInfo.distance = listDistance[previousLocation] - listDistance[i];
                type.setTurnAngle(360.0f - delta);
                previousInfo = new RouteDirectionInfo(speed, type);
                previousInfo.setDescriptionRoute(description);
                previousInfo.routePointOffset = startTurnPoint;
                computeDirections.add(previousInfo);
                previousLocation = startTurnPoint;
                prevBearingLocation = i;
            }
            distForTurn = 0;
        }
        previousInfo.distance = listDistance[previousLocation];
        if (originalDirections.isEmpty()) {
            originalDirections.addAll(computeDirections);
        } else {
            int currentDirection = 0;
            block5: for (int i = 0; i <= originalDirections.size() && currentDirection < computeDirections.size(); ++i) {
                while (currentDirection < computeDirections.size()) {
                    int distanceAfter = 0;
                    if (i < originalDirections.size()) {
                        RouteDirectionInfo resInfo = originalDirections.get(i);
                        int r1 = ((RouteDirectionInfo)computeDirections.get((int)currentDirection)).routePointOffset;
                        int r2 = resInfo.routePointOffset;
                        distanceAfter = listDistance[resInfo.routePointOffset];
                        float dist = locations.get(r1).distanceTo(locations.get(r2));
                        if (dist < 100.0f) {
                            ++currentDirection;
                            continue;
                        }
                        if (((RouteDirectionInfo)computeDirections.get((int)currentDirection)).routePointOffset > resInfo.routePointOffset) continue block5;
                    }
                    RouteDirectionInfo toAdd = (RouteDirectionInfo)computeDirections.get(currentDirection);
                    if (i > 0) {
                        RouteDirectionInfo previous = originalDirections.get(i - 1);
                        toAdd.setAverageSpeed(previous.getAverageSpeed());
                    }
                    toAdd.distance = listDistance[toAdd.routePointOffset] - distanceAfter;
                    if (i < originalDirections.size()) {
                        originalDirections.add(i, toAdd);
                    } else {
                        originalDirections.add(toAdd);
                    }
                    ++i;
                    ++currentDirection;
                }
            }
        }
        int sum = 0;
        for (int i = originalDirections.size() - 1; i >= 0; --i) {
            originalDirections.get((int)i).afterLeftTime = sum;
            sum += originalDirections.get(i).getExpectedTime();
        }
    }

    public static String toString(TurnType type, OsmWindow ctx) {
        if (type.isRoundAbout()) {
            return ctx.getString(174, type.getExitOut());
        }
        if (type.getValue() == 1) {
            return ctx.getString(694);
        }
        if (type.getValue() == 3) {
            return ctx.getString(692);
        }
        if (type.getValue() == 2) {
            return ctx.getString(690);
        }
        if (type.getValue() == 4) {
            return ctx.getString(691);
        }
        if (type.getValue() == 6) {
            return ctx.getString(689);
        }
        if (type.getValue() == 5) {
            return ctx.getString(687);
        }
        if (type.getValue() == 7) {
            return ctx.getString(688);
        }
        if (type.getValue() == 10) {
            return ctx.getString(693);
        }
        if (type.getValue() == 11) {
            return ctx.getString(693);
        }
        if (type.getValue() == 8) {
            return ctx.getString(175);
        }
        if (type.getValue() == 9) {
            return ctx.getString(176);
        }
        return "";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void removeUnnecessaryGoAhead(List<RouteDirectionInfo> directions) {
        if (directions != null && directions.size() > 1) {
            int i = 1;
            while (i < directions.size()) {
                RouteDirectionInfo r = directions.get(i);
                if (r.getTurnType().getValue() == 1) {
                    RouteDirectionInfo prev = directions.get(i - 1);
                    prev.setAverageSpeed((float)(prev.distance + r.distance) / ((float)prev.distance / prev.getAverageSpeed() + (float)r.distance / r.getAverageSpeed()));
                    directions.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    private void checkForDuplicatePoints(List<Location> locations, List<RouteDirectionInfo> directions) {
        int i = 0;
        while (i < locations.size() - 1) {
            if (locations.get(i).distanceTo(locations.get(i + 1)) == 0.0f) {
                locations.remove(i);
                if (directions == null) continue;
                for (RouteDirectionInfo info : directions) {
                    if (info.routePointOffset <= i) continue;
                    --info.routePointOffset;
                }
                continue;
            }
            ++i;
        }
    }

    private static void introduceFirstPointAndLastPoint(List<Location> locations, List<RouteDirectionInfo> directions, List<RouteSegmentResult> segs, Location start, LatLon end) {
        RouteDirectionInfo lastDirInf;
        if (!locations.isEmpty() && locations.get(0).distanceTo(start) > 50.0f) {
            locations.add(0, start);
            if (segs != null) {
                segs.add(0, segs.get(0));
            }
            if (directions != null && !directions.isEmpty()) {
                for (RouteDirectionInfo i : directions) {
                    ++i.routePointOffset;
                }
                RouteDirectionInfo info = new RouteDirectionInfo(directions.get(0).getAverageSpeed(), TurnType.straight());
                info.routePointOffset = 0;
                directions.add(0, info);
            }
        }
        RouteDirectionInfo routeDirectionInfo = lastDirInf = directions.size() > 0 ? directions.get(directions.size() - 1) : null;
        if ((lastDirInf == null || lastDirInf.routePointOffset < locations.size() - 1) && locations.size() - 1 > 0) {
            int type = 1;
            Location prevLast = locations.get(locations.size() - 2);
            float lastBearing = prevLast.bearingTo(locations.get(locations.size() - 1));
            float[] compute = new float[2];
            Location.distanceBetween(prevLast.getLatitude(), prevLast.getLongitude(), end.getLatitude(), end.getLongitude(), compute);
            float bearingToEnd = compute[1];
            double diff = MapUtils.degreesDiff(lastBearing, bearingToEnd);
            if (Math.abs(diff) > 10.0) {
                type = diff > 0.0 ? 8 : 9;
            }
            RouteDirectionInfo info = new RouteDirectionInfo(1.0f, TurnType.valueOf(type, false));
            info.distance = 0;
            info.afterLeftTime = 0;
            info.routePointOffset = locations.size() - 1;
            directions.add(info);
        }
    }

    private static void updateListDistanceTime(int[] listDistance, List<Location> locations) {
        if (listDistance.length > 0) {
            listDistance[locations.size() - 1] = 0;
            for (int i = locations.size() - 1; i > 0; --i) {
                listDistance[i - 1] = (int)locations.get(i - 1).distanceTo(locations.get(i));
                int n = i - 1;
                listDistance[n] = listDistance[n] + listDistance[i];
            }
        }
    }

    private static void updateDirectionsTime(List<RouteDirectionInfo> directions, int[] listDistance) {
        int sum = 0;
        for (int i = directions.size() - 1; i >= 0; --i) {
            directions.get((int)i).afterLeftTime = sum;
            directions.get((int)i).distance = listDistance[directions.get((int)i).routePointOffset];
            if (i < directions.size() - 1) {
                directions.get((int)i).distance -= listDistance[directions.get((int)(i + 1)).routePointOffset];
            }
            sum += directions.get(i).getExpectedTime();
        }
    }

    public List<Location> getImmutableAllLocations() {
        return this.locations;
    }

    public List<RouteDirectionInfo> getImmutableAllDirections() {
        return this.directions;
    }

    public List<Location> getRouteLocations() {
        if (this.currentRoute < this.locations.size()) {
            return this.locations.subList(this.currentRoute, this.locations.size());
        }
        return Collections.emptyList();
    }

    public RouteSegmentResult getCurrentSegmentResult() {
        int cs;
        int n = cs = this.currentRoute > 0 ? this.currentRoute - 1 : 0;
        if (cs < this.segments.size()) {
            return this.segments.get(cs);
        }
        return null;
    }

    public List<RouteSegmentResult> getUpcomingTunnel(float distToStart) {
        int cs;
        int n = cs = this.currentRoute > 0 ? this.currentRoute - 1 : 0;
        if (cs < this.segments.size()) {
            RouteSegmentResult prev = null;
            boolean tunnel = false;
            while (cs < this.segments.size() && distToStart > 0.0f) {
                RouteSegmentResult segment = this.segments.get(cs);
                if (segment != prev) {
                    if (segment.getObject().tunnel()) {
                        tunnel = true;
                        break;
                    }
                    distToStart -= segment.getDistance();
                    prev = segment;
                }
                ++cs;
            }
            if (tunnel) {
                ArrayList<RouteSegmentResult> list = new ArrayList<RouteSegmentResult>();
                while (cs < this.segments.size()) {
                    RouteSegmentResult segment = this.segments.get(cs);
                    if (segment != prev) {
                        if (!segment.getObject().tunnel()) break;
                        list.add(segment);
                        prev = segment;
                    }
                    ++cs;
                }
                return list;
            }
        }
        return null;
    }

    public float getCurrentMaxSpeed() {
        RouteSegmentResult res = this.getCurrentSegmentResult();
        if (res != null) {
            return res.getObject().getMaximumSpeed(res.isForwardDirection());
        }
        return 0.0f;
    }

    public float getRoutingTime() {
        return this.routingTime;
    }

    public int getWholeDistance() {
        if (this.listDistance.length > 0) {
            return this.listDistance[0];
        }
        return 0;
    }

    public boolean isCalculated() {
        return !this.locations.isEmpty();
    }

    public boolean isEmpty() {
        return this.locations.isEmpty() || this.currentRoute >= this.locations.size();
    }

    public void updateCurrentRoute(int currentRoute) {
        this.currentRoute = currentRoute;
        while (this.currentDirectionInfo < this.directions.size() - 1 && this.directions.get((int)(this.currentDirectionInfo + 1)).routePointOffset < currentRoute && this.directions.get((int)(this.currentDirectionInfo + 1)).routeEndPointOffset < currentRoute) {
            ++this.currentDirectionInfo;
        }
        while (this.nextIntermediate < this.intermediatePoints.length) {
            RouteDirectionInfo dir = this.directions.get(this.intermediatePoints[this.nextIntermediate]);
            if (dir.routePointOffset >= currentRoute) break;
            ++this.nextIntermediate;
        }
    }

    public int getCurrentRoute() {
        return this.currentRoute;
    }

    public void passIntermediatePoint() {
        ++this.nextIntermediate;
    }

    public Location getLocationFromRouteDirection(RouteDirectionInfo i) {
        if (i.routePointOffset < this.locations.size()) {
            return this.locations.get(i.routePointOffset);
        }
        return null;
    }

    NextDirectionInfo getNextRouteDirectionInfo(NextDirectionInfo info, Location fromLoc, boolean toSpeak) {
        int dirInfo = this.currentDirectionInfo;
        if (dirInfo < this.directions.size()) {
            int nextInd;
            if (toSpeak) {
                RouteDirectionInfo i;
                for (nextInd = dirInfo + 1; nextInd < this.directions.size() && ((i = this.directions.get(nextInd)).getTurnType() == null || i.getTurnType().isSkipToSpeak()); ++nextInd) {
                }
            }
            int dist = this.listDistance[this.currentRoute];
            if (fromLoc != null) {
                dist = (int)((float)dist + fromLoc.distanceTo(this.locations.get(this.currentRoute)));
            }
            if (nextInd < this.directions.size()) {
                info.directionInfo = this.directions.get(nextInd);
                dist = this.directions.get((int)nextInd).routePointOffset <= this.currentRoute && this.currentRoute <= this.directions.get((int)nextInd).routeEndPointOffset ? (dist -= this.listDistance[this.directions.get((int)nextInd).routeEndPointOffset]) : (dist -= this.listDistance[this.directions.get((int)nextInd).routePointOffset]);
            }
            if (this.intermediatePoints != null && this.nextIntermediate < this.intermediatePoints.length) {
                info.intermediatePoint = this.intermediatePoints[this.nextIntermediate] == nextInd;
            }
            info.directionInfoInd = nextInd;
            info.distanceTo = dist;
            return info;
        }
        info.directionInfoInd = -1;
        info.distanceTo = -1;
        info.directionInfo = null;
        return null;
    }

    NextDirectionInfo getNextRouteDirectionInfoAfter(NextDirectionInfo prev, NextDirectionInfo next, boolean toSpeak) {
        int dirInfo = prev.directionInfoInd;
        if (dirInfo < this.directions.size() && prev.directionInfo != null) {
            int nextInd;
            int dist = this.listDistance[prev.directionInfo.routePointOffset];
            if (toSpeak) {
                RouteDirectionInfo i;
                for (nextInd = dirInfo + 1; nextInd < this.directions.size() && ((i = this.directions.get(nextInd)).getTurnType() == null || i.getTurnType().isSkipToSpeak()); ++nextInd) {
                }
            }
            if (nextInd < this.directions.size()) {
                next.directionInfo = this.directions.get(nextInd);
                dist -= this.listDistance[this.directions.get((int)nextInd).routePointOffset];
            }
            if (this.intermediatePoints != null && this.nextIntermediate < this.intermediatePoints.length) {
                next.intermediatePoint = this.intermediatePoints[this.nextIntermediate] == nextInd;
            }
            next.distanceTo = dist;
            next.directionInfoInd = nextInd;
            return next;
        }
        next.directionInfoInd = -1;
        next.distanceTo = -1;
        next.directionInfo = null;
        return null;
    }

    public List<RouteDirectionInfo> getRouteDirections() {
        if (this.currentDirectionInfo < this.directions.size() - 1) {
            if (this.cacheCurrentTextDirectionInfo != this.currentDirectionInfo) {
                this.cacheCurrentTextDirectionInfo = this.currentDirectionInfo;
                List<RouteDirectionInfo> list = this.currentDirectionInfo == 0 ? this.directions : this.directions.subList(this.currentDirectionInfo + 1, this.directions.size());
                this.cacheAgreggatedDirections = new ArrayList<RouteDirectionInfo>();
                RouteDirectionInfo p = null;
                for (RouteDirectionInfo i : list) {
                    if (p == null || !i.getTurnType().isSkipToSpeak() || !Algorithms.objectEquals(p.getRef(), i.getRef()) && !Algorithms.objectEquals(p.getStreetName(), i.getStreetName())) {
                        p = new RouteDirectionInfo(i.getAverageSpeed(), i.getTurnType());
                        p.routePointOffset = i.routePointOffset;
                        p.routeEndPointOffset = i.routeEndPointOffset;
                        p.setDestinationName(i.getDestinationName());
                        p.setRef(i.getRef());
                        p.setStreetName(i.getStreetName());
                        p.setDescriptionRoute(i.getDescriptionRoutePart());
                        this.cacheAgreggatedDirections.add(p);
                    }
                    float time = i.getExpectedTime() + p.getExpectedTime();
                    p.distance += i.distance;
                    p.setAverageSpeed((float)p.distance / time);
                    p.afterLeftTime = i.afterLeftTime;
                }
            }
            return this.cacheAgreggatedDirections;
        }
        return Collections.emptyList();
    }

    public Location getNextRouteLocation() {
        if (this.currentRoute < this.locations.size()) {
            return this.locations.get(this.currentRoute);
        }
        return null;
    }

    public Location getNextRouteLocation(int after) {
        if (this.currentRoute + after < this.locations.size()) {
            return this.locations.get(this.currentRoute + after);
        }
        return null;
    }

    public boolean directionsAvailable() {
        return this.currentDirectionInfo < this.directions.size();
    }

    public int getDistanceToPoint(int locationIndex) {
        if (this.listDistance != null && this.currentRoute < this.listDistance.length && locationIndex < this.listDistance.length && locationIndex > this.currentRoute) {
            return this.listDistance[this.currentRoute] - this.listDistance[locationIndex];
        }
        return 0;
    }

    public int getDistanceToFinish(Location fromLoc) {
        if (this.listDistance != null && this.currentRoute < this.listDistance.length) {
            int dist = this.listDistance[this.currentRoute];
            Location l = this.locations.get(this.currentRoute);
            if (fromLoc != null) {
                dist = (int)((float)dist + fromLoc.distanceTo(l));
            }
            return dist;
        }
        return 0;
    }

    public int getDistanceToNextIntermediate(Location fromLoc) {
        if (this.listDistance != null && this.currentRoute < this.listDistance.length) {
            int dist = this.listDistance[this.currentRoute];
            Location l = this.locations.get(this.currentRoute);
            if (fromLoc != null) {
                dist = (int)((float)dist + fromLoc.distanceTo(l));
            }
            if (this.nextIntermediate >= this.intermediatePoints.length) {
                return 0;
            }
            int directionInd = this.intermediatePoints[this.nextIntermediate];
            return dist - this.listDistance[this.directions.get((int)directionInd).routePointOffset];
        }
        return 0;
    }

    public int getIndexOfIntermediate(int countFromLast) {
        int j = this.intermediatePoints.length - countFromLast - 1;
        if (j < this.intermediatePoints.length && j >= 0) {
            int i = this.intermediatePoints[j];
            return this.directions.get((int)i).routePointOffset;
        }
        return -1;
    }

    public int getIntermediatePointsToPass() {
        if (this.nextIntermediate >= this.intermediatePoints.length) {
            return 0;
        }
        return this.intermediatePoints.length - this.nextIntermediate;
    }

    public int getLeftTime(Location fromLoc) {
        int time = 0;
        if (this.currentDirectionInfo < this.directions.size()) {
            RouteDirectionInfo current = this.directions.get(this.currentDirectionInfo);
            time = current.afterLeftTime;
            int distanceToNextTurn = this.listDistance[this.currentRoute];
            if (this.currentDirectionInfo + 1 < this.directions.size()) {
                distanceToNextTurn -= this.listDistance[this.directions.get((int)(this.currentDirectionInfo + 1)).routePointOffset];
            }
            Location l = this.locations.get(this.currentRoute);
            if (fromLoc != null) {
                distanceToNextTurn = (int)((float)distanceToNextTurn + fromLoc.distanceTo(l));
            }
            time = (int)((float)time + (float)distanceToNextTurn / current.getAverageSpeed());
        }
        return time;
    }

    public static class NextDirectionInfo {
        public RouteDirectionInfo directionInfo;
        public int distanceTo;
        public boolean intermediatePoint;
        public String pointName;
        public int imminent;
        private int directionInfoInd;
    }
}

