/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.parse.ParseExpression;
import org.opensearch.sql.planner.SerializablePlan;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import shaded.com.google.common.collect.ImmutableMap;

public class ProjectOperator
extends PhysicalPlan
implements SerializablePlan {
    private PhysicalPlan input;
    private List<NamedExpression> projectList;
    private List<NamedExpression> namedParseExpressions;

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext();
    }

    @Override
    public ExprValue next() {
        ExprValue inputValue = (ExprValue)this.input.next();
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (NamedExpression expr : this.projectList) {
            ExprValue exprValue = expr.valueOf(inputValue.bindingTuples());
            Optional<NamedExpression> optionalParseExpression = this.namedParseExpressions.stream().filter(parseExpr -> parseExpr.getNameOrAlias().equals(expr.getNameOrAlias())).findFirst();
            if (optionalParseExpression.isEmpty()) {
                mapBuilder.put((Object)expr.getNameOrAlias(), (Object)exprValue);
                continue;
            }
            NamedExpression parseExpression = optionalParseExpression.get();
            ExprValue sourceFieldValue = inputValue.bindingTuples().resolve(((ParseExpression)parseExpression.getDelegated()).getSourceField());
            if (sourceFieldValue.isMissing()) {
                ExprValue tupleValue = ExprValueUtils.getTupleValue(inputValue).get(parseExpression.getNameOrAlias());
                if (tupleValue == null) continue;
                mapBuilder.put((Object)parseExpression.getNameOrAlias(), (Object)tupleValue);
                continue;
            }
            ExprValue parsedValue = parseExpression.valueOf(inputValue.bindingTuples());
            mapBuilder.put((Object)parseExpression.getNameOrAlias(), (Object)parsedValue);
        }
        return ExprTupleValue.fromExprValueMap((Map<String, ExprValue>)mapBuilder.build());
    }

    @Override
    public ExecutionEngine.Schema schema() {
        return new ExecutionEngine.Schema(this.getProjectList().stream().map(expr -> new ExecutionEngine.Schema.Column(expr.getName(), expr.getAlias(), expr.type())).collect(Collectors.toList()));
    }

    @Deprecated
    public ProjectOperator() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.projectList = (List)in.readObject();
        this.namedParseExpressions = List.of();
        this.input = (PhysicalPlan)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.projectList);
        out.writeObject(((SerializablePlan)((Object)this.input)).getPlanForSerialization());
    }

    @Generated
    public String toString() {
        return "ProjectOperator(input=" + String.valueOf(this.getInput()) + ", projectList=" + String.valueOf(this.getProjectList()) + ", namedParseExpressions=" + String.valueOf(this.getNamedParseExpressions()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectOperator)) {
            return false;
        }
        ProjectOperator other = (ProjectOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<NamedExpression> this$projectList = this.getProjectList();
        List<NamedExpression> other$projectList = other.getProjectList();
        if (this$projectList == null ? other$projectList != null : !((Object)this$projectList).equals(other$projectList)) {
            return false;
        }
        List<NamedExpression> this$namedParseExpressions = this.getNamedParseExpressions();
        List<NamedExpression> other$namedParseExpressions = other.getNamedParseExpressions();
        return !(this$namedParseExpressions == null ? other$namedParseExpressions != null : !((Object)this$namedParseExpressions).equals(other$namedParseExpressions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjectOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<NamedExpression> $projectList = this.getProjectList();
        result = result * 59 + ($projectList == null ? 43 : ((Object)$projectList).hashCode());
        List<NamedExpression> $namedParseExpressions = this.getNamedParseExpressions();
        result = result * 59 + ($namedParseExpressions == null ? 43 : ((Object)$namedParseExpressions).hashCode());
        return result;
    }

    @Generated
    public ProjectOperator(PhysicalPlan input, List<NamedExpression> projectList, List<NamedExpression> namedParseExpressions) {
        this.input = input;
        this.projectList = projectList;
        this.namedParseExpressions = namedParseExpressions;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<NamedExpression> getProjectList() {
        return this.projectList;
    }

    @Generated
    public List<NamedExpression> getNamedParseExpressions() {
        return this.namedParseExpressions;
    }
}

