/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.Argon2Function;
import com.password4j.BalloonHashingFunction;
import com.password4j.BcryptFunction;
import com.password4j.CompressedPBKDF2Function;
import com.password4j.MessageDigestFunction;
import com.password4j.PBKDF2Function;
import com.password4j.PropertyReader;
import com.password4j.SaltOption;
import com.password4j.ScryptFunction;
import com.password4j.Utils;
import com.password4j.types.Argon2;
import com.password4j.types.Bcrypt;
import com.password4j.types.Hmac;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AlgorithmFinder.class);
    private static SecureRandom secureRandom;

    private AlgorithmFinder() {
    }

    public static SecureRandom getSecureRandom() {
        return secureRandom;
    }

    public static PBKDF2Function getPBKDF2Instance() {
        Param params = AlgorithmFinder.internalGetProperties();
        return PBKDF2Function.getInstance(params.algorithm, params.iterations, params.length);
    }

    public static CompressedPBKDF2Function getCompressedPBKDF2Instance() {
        Param params = AlgorithmFinder.internalGetProperties();
        return CompressedPBKDF2Function.getInstance(params.algorithm, params.iterations, params.length);
    }

    private static Param internalGetProperties() {
        String algorithm = PropertyReader.readString("hash.pbkdf2.algorithm", Hmac.SHA256.name(), "PBKDF2 algorithm is not defined");
        int iterations = PropertyReader.readInt("hash.pbkdf2.iterations", 310000, "PBKDF2 #iterations are not defined");
        int length = PropertyReader.readInt("hash.pbkdf2.length", Hmac.SHA256.bits(), "PBKDF2 key length is not defined");
        return new Param(algorithm, iterations, length);
    }

    public static BcryptFunction getBcryptInstance() {
        char minor = PropertyReader.readChar("hash.bcrypt.minor", 'b', "bcrypt minor version is not defined");
        int rounds = PropertyReader.readInt("hash.bcrypt.rounds", 10, "bcrypt rounds are not defined");
        return BcryptFunction.getInstance(Bcrypt.valueOf(minor), rounds);
    }

    public static ScryptFunction getScryptInstance() {
        int workFactor = PropertyReader.readInt("hash.scrypt.workfactor", 65536, "scrypt work factor (N) is not defined");
        int resources = PropertyReader.readInt("hash.scrypt.resources", 8, "scrypt resources (r) is not defined");
        int parallelization = PropertyReader.readInt("hash.scrypt.parallelization", 1, "scrypt parallelization (p) is not defined");
        int derivedKeyLength = PropertyReader.readInt("hash.scrypt.derivedKeyLength", 64, "scrypt derivedKeyLength (dkLen) is not defined");
        return ScryptFunction.getInstance(workFactor, resources, parallelization, derivedKeyLength);
    }

    public static MessageDigestFunction getMessageDigestInstance() {
        String algorithm = PropertyReader.readString("hash.md.algorithm", "SHA-512", "Message Digest algorithm is not defined");
        String saltOption = PropertyReader.readString("hash.md.salt.option", "APPEND", "Salt option is not defined");
        try {
            return MessageDigestFunction.getInstance(algorithm, SaltOption.valueOf(saltOption.toUpperCase()));
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("{} is not a valid option. Fallback to default.", (Object)saltOption);
            return MessageDigestFunction.getInstance(algorithm);
        }
    }

    public static Argon2Function getArgon2Instance() {
        int memory = PropertyReader.readInt("hash.argon2.memory", 15360, "Argon2 memory is not defined");
        int iterations = PropertyReader.readInt("hash.argon2.iterations", 2, "Argon2 #iterations is not defined");
        int outputLength = PropertyReader.readInt("hash.argon2.length", 32, "Argon2 output length is not defined");
        int parallelism = PropertyReader.readInt("hash.argon2.parallelism", 1, "Argon2 parallelism is not defined");
        String type = PropertyReader.readString("hash.argon2.type", "id", "Argon2 type is not defined");
        int version = PropertyReader.readInt("hash.argon2.version", 19, "Argon2 version is not defined");
        return Argon2Function.getInstance(memory, iterations, parallelism, outputLength, Argon2.valueOf(type.toUpperCase()), version);
    }

    public static BalloonHashingFunction getBalloonHashingInstance() {
        int space = PropertyReader.readInt("hash.balloon.space", 1024, "BalloonHashing memory (space) is not defined");
        int time = PropertyReader.readInt("hash.balloon.time", 3, "BalloonHashing #iterations (time) is not defined");
        int parallelism = PropertyReader.readInt("hash.balloon.parallelism", 1, "BalloonHashing parallelism is not defined");
        int delta = PropertyReader.readInt("hash.balloon.delta", 3, "BalloonHashing delta is not defined");
        String algorithm = PropertyReader.readString("hash.balloon.algorithm", "SHA-256", "BalloonHashing algorithm is not defined");
        return BalloonHashingFunction.getInstance(algorithm, space, time, parallelism, delta);
    }

    public static List<String> getAllPBKDF2Variants() {
        ArrayList<String> result = new ArrayList<String>();
        for (Provider provider : Security.getProviders()) {
            if (provider.getServices() == null) continue;
            for (Provider.Service service : provider.getServices()) {
                if (!"SecretKeyFactory".equals(service.getType()) || !service.getAlgorithm().startsWith("PBKDF2")) continue;
                result.add(service.getAlgorithm());
            }
        }
        return result;
    }

    public static Set<String> getAllMessageDigests() {
        return Security.getAlgorithms("MessageDigest");
    }

    private static boolean useStrongRandom() {
        return PropertyReader.readBoolean("global.random.strong", false);
    }

    static void initialize() {
        SecureRandom sr;
        if (AlgorithmFinder.useStrongRandom()) {
            try {
                sr = Utils.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.warn("No source of strong randomness found for this environment.");
                sr = new SecureRandom();
            }
        } else {
            sr = new SecureRandom();
        }
        secureRandom = sr;
    }

    static {
        AlgorithmFinder.initialize();
    }

    private static class Param {
        String algorithm;
        int iterations;
        int length;

        Param(String algorithm, int iterations, int length) {
            this.algorithm = algorithm;
            this.iterations = iterations;
            this.length = length;
        }
    }
}

