/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jdesktop.swingx.plaf.basic.BasicTitledPanelUI;

public class FlatTitledPanelUI
extends BasicTitledPanelUI {
    public static ComponentUI createUI(JComponent c) {
        return new FlatTitledPanelUI();
    }

    protected void installDefaults(JXTitledPanel titledPanel) {
        super.installDefaults(titledPanel);
        this.installProperty((JComponent)titledPanel, "titlePainter", new PainterUIResource((Painter)new TitlePainter(UIManager.getColor("JXTitledPanel.titleBackground"), UIManager.getColor("JXTitledPanel.borderColor"))));
        this.installProperty((JComponent)titledPanel, "titleFont", UIManager.getFont("JXTitledPanel.titleFont").deriveFont(1));
    }

    protected void installComponents(JXTitledPanel titledPanel) {
        super.installComponents(titledPanel);
        if (SwingXUtilities.isUIInstallable((Object)titledPanel.getBorder())) {
            titledPanel.setBorder((Border)new FlatLineBorder(new Insets(1, 1, 1, 1), UIManager.getColor("JXTitledPanel.borderColor")));
        }
    }

    protected Insets getCaptionInsets() {
        return UIScale.scale((Insets)super.getCaptionInsets());
    }

    private static class TitlePainter
    extends MattePainter {
        private final Color borderColor;

        TitlePainter(Color color, Color borderColor) {
            super((Paint)color);
            this.borderColor = borderColor;
        }

        protected void doPaint(Graphics2D g, Object component, int width, int height) {
            super.doPaint(g, component, width, height);
            float h = UIScale.scale((float)1.0f);
            g.setColor(this.borderColor);
            g.fill(new Rectangle2D.Float(0.0f, (float)height - h, width, h));
        }
    }
}

