/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.jpa.JpaHashUtils;
import org.keycloak.storage.jpa.entity.BrokerLinkEntity;
import org.keycloak.storage.jpa.entity.FederatedUser;
import org.keycloak.storage.jpa.entity.FederatedUserAttributeEntity;
import org.keycloak.storage.jpa.entity.FederatedUserConsentClientScopeEntity;
import org.keycloak.storage.jpa.entity.FederatedUserConsentEntity;
import org.keycloak.storage.jpa.entity.FederatedUserCredentialEntity;
import org.keycloak.storage.jpa.entity.FederatedUserGroupMembershipEntity;
import org.keycloak.storage.jpa.entity.FederatedUserRequiredActionEntity;
import org.keycloak.storage.jpa.entity.FederatedUserRoleMappingEntity;
import org.keycloak.utils.StreamsUtil;

public class JpaUserFederatedStorageProvider
implements UserFederatedStorageProvider,
UserCredentialStore {
    protected static final Logger logger = Logger.getLogger(JpaUserFederatedStorageProvider.class);
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaUserFederatedStorageProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void close() {
    }

    protected void createIndex(RealmModel realm, String userId) {
        if (this.em.find(FederatedUser.class, (Object)userId) == null) {
            FederatedUser fedUser = new FederatedUser();
            fedUser.setId(userId);
            fedUser.setRealmId(realm.getId());
            fedUser.setStorageProviderId(new StorageId(userId).getProviderId());
            this.em.persist((Object)fedUser);
        }
    }

    public void setAttribute(RealmModel realm, String userId, String name, List<String> values) {
        this.createIndex(realm, userId);
        this.deleteAttribute(realm, userId, name);
        this.em.flush();
        for (String value : values) {
            this.persistAttributeValue(realm, userId, name, value);
        }
    }

    private void deleteAttribute(RealmModel realm, String userId, String name) {
        this.em.createNamedQuery("deleteUserFederatedAttributesByUserAndName").setParameter("userId", (Object)userId).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)name).executeUpdate();
    }

    private void persistAttributeValue(RealmModel realm, String userId, String name, String value) {
        FederatedUserAttributeEntity attr = new FederatedUserAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setUserId(userId);
        attr.setRealmId(realm.getId());
        attr.setStorageProviderId(new StorageId(userId).getProviderId());
        this.em.persist((Object)attr);
    }

    public void setSingleAttribute(RealmModel realm, String userId, String name, String value) {
        this.createIndex(realm, userId);
        this.deleteAttribute(realm, userId, name);
        this.em.flush();
        this.persistAttributeValue(realm, userId, name, value);
    }

    public void removeAttribute(RealmModel realm, String userId, String name) {
        this.deleteAttribute(realm, userId, name);
        this.em.flush();
    }

    public MultivaluedHashMap<String, String> getAttributes(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("getFederatedAttributesByUser", FederatedUserAttributeEntity.class);
        List list = query.setParameter("userId", (Object)userId).setParameter("realmId", (Object)realm.getId()).getResultList();
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (FederatedUserAttributeEntity entity : list) {
            result.add((Object)entity.getName(), (Object)entity.getValue());
        }
        return result;
    }

    public Stream<String> getUsersByUserAttributeStream(RealmModel realm, String name, String value) {
        boolean longAttribute;
        boolean bl = longAttribute = value != null && value.length() > 2024;
        if (longAttribute) {
            TypedQuery query = this.em.createNamedQuery("getFederatedAttributesByNameAndLongValue", Object[].class).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)name).setParameter("longValueHash", (Object)JpaHashUtils.hashForAttributeValue(value));
            return StreamsUtil.closing(query.getResultStream().filter(objects -> JpaHashUtils.compareSourceValue((String)objects[1], value)).map(objects -> (String)objects[0]));
        }
        TypedQuery query = this.em.createNamedQuery("getFederatedAttributesByNameAndValue", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)name).setParameter("value", (Object)value);
        return StreamsUtil.closing((Stream)query.getResultStream());
    }

    public String getUserByFederatedIdentity(FederatedIdentityModel link, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findUserByBrokerLinkAndRealm", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("identityProvider", (Object)link.getIdentityProvider()).setParameter("brokerUserId", (Object)link.getUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for identityProvider=" + link.getIdentityProvider() + ", userId=" + link.getUserId() + ", results=" + String.valueOf(results));
        }
        return (String)results.get(0);
    }

    public void addFederatedIdentity(RealmModel realm, String userId, FederatedIdentityModel link) {
        this.createIndex(realm, userId);
        BrokerLinkEntity entity = new BrokerLinkEntity();
        entity.setRealmId(realm.getId());
        entity.setUserId(userId);
        entity.setBrokerUserId(link.getUserId());
        entity.setIdentityProvider(link.getIdentityProvider());
        entity.setToken(link.getToken());
        entity.setBrokerUserName(link.getUserName());
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        this.em.persist((Object)entity);
    }

    public boolean removeFederatedIdentity(RealmModel realm, String userId, String socialProvider) {
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, userId, socialProvider);
        if (entity == null) {
            return false;
        }
        this.em.remove((Object)entity);
        return true;
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        this.em.createNamedQuery("deleteBrokerLinkByIdentityProvider").setParameter("realmId", (Object)realm.getId()).setParameter("providerAlias", (Object)provider.getAlias()).executeUpdate();
    }

    private BrokerLinkEntity getBrokerLinkEntity(RealmModel realm, String userId, String socialProvider) {
        TypedQuery query = this.em.createNamedQuery("findBrokerLinkByUserAndProvider", BrokerLinkEntity.class).setParameter("userId", (Object)userId).setParameter("realmId", (Object)realm.getId()).setParameter("identityProvider", (Object)socialProvider);
        List results = query.getResultList();
        return results.size() > 0 ? (BrokerLinkEntity)results.get(0) : null;
    }

    public void updateFederatedIdentity(RealmModel realm, String userId, FederatedIdentityModel model) {
        this.createIndex(realm, userId);
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, userId, model.getIdentityProvider());
        if (entity == null) {
            return;
        }
        entity.setBrokerUserName(model.getUserName());
        entity.setBrokerUserId(model.getUserId());
        entity.setToken(model.getToken());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(String userId, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findBrokerLinkByUser", BrokerLinkEntity.class).setParameter("userId", (Object)userId);
        return StreamsUtil.closing(query.getResultStream().map(entity -> new FederatedIdentityModel(entity.getIdentityProvider(), entity.getBrokerUserId(), entity.getBrokerUserName(), entity.getToken())).distinct());
    }

    public FederatedIdentityModel getFederatedIdentity(String userId, String socialProvider, RealmModel realm) {
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, userId, socialProvider);
        if (entity == null) {
            return null;
        }
        return new FederatedIdentityModel(entity.getIdentityProvider(), entity.getBrokerUserId(), entity.getBrokerUserName(), entity.getToken());
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.createIndex(realm, userId);
        String clientId = consent.getClient().getId();
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId, LockModeType.NONE);
        if (consentEntity != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + userId + "]");
        }
        consentEntity = new FederatedUserConsentEntity();
        consentEntity.setId(KeycloakModelUtils.generateId());
        consentEntity.setUserId(userId);
        StorageId clientStorageId = new StorageId(clientId);
        if (clientStorageId.isLocal()) {
            consentEntity.setClientId(clientId);
        } else {
            consentEntity.setClientStorageProvider(clientStorageId.getProviderId());
            consentEntity.setExternalClientId(clientStorageId.getExternalId());
        }
        consentEntity.setRealmId(realm.getId());
        consentEntity.setStorageProviderId(new StorageId(userId).getProviderId());
        long currentTime = Time.currentTimeMillis();
        consentEntity.setCreatedDate(currentTime);
        consentEntity.setLastUpdatedDate(currentTime);
        this.em.persist((Object)consentEntity);
        this.em.flush();
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        FederatedUserConsentEntity entity = this.getGrantedConsentEntity(userId, clientInternalId, LockModeType.NONE);
        return this.toConsentModel(realm, entity);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("userFederatedConsentsByUser", FederatedUserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        return StreamsUtil.closing(query.getResultStream().map(entity -> this.toConsentModel(realm, (FederatedUserConsentEntity)entity)));
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.createIndex(realm, userId);
        String clientId = consent.getClient().getId();
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId, LockModeType.PESSIMISTIC_WRITE);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + userId + "]");
        }
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientInternalId, LockModeType.PESSIMISTIC_WRITE);
        if (consentEntity == null) {
            return false;
        }
        this.em.remove((Object)consentEntity);
        this.em.flush();
        return true;
    }

    private FederatedUserConsentEntity getGrantedConsentEntity(String userId, String clientId, LockModeType lockMode) {
        StorageId clientStorageId = new StorageId(clientId);
        String queryName = clientStorageId.isLocal() ? "userFederatedConsentByUserAndClient" : "userFederatedConsentByUserAndExternalClient";
        TypedQuery query = this.em.createNamedQuery(queryName, FederatedUserConsentEntity.class);
        query.setLockMode(lockMode);
        query.setParameter("userId", (Object)userId);
        if (clientStorageId.isLocal()) {
            query.setParameter("clientId", (Object)clientId);
        } else {
            query.setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId());
            query.setParameter("externalClientId", (Object)clientStorageId.getExternalId());
        }
        List results = query.getResultList();
        if (results.size() > 1) {
            throw new ModelException("More results found for user [" + userId + "] and client [" + clientId + "]");
        }
        if (results.size() == 1) {
            return (FederatedUserConsentEntity)results.get(0);
        }
        return null;
    }

    private UserConsentModel toConsentModel(RealmModel realm, FederatedUserConsentEntity entity) {
        if (entity == null) {
            return null;
        }
        StorageId clientStorageId = null;
        clientStorageId = entity.getClientId() == null ? new StorageId(entity.getClientStorageProvider(), entity.getExternalClientId()) : new StorageId(entity.getClientId());
        ClientModel client = realm.getClientById(clientStorageId.getId());
        UserConsentModel model = new UserConsentModel(client);
        model.setCreatedDate(entity.getCreatedDate());
        model.setLastUpdatedDate(entity.getLastUpdatedDate());
        Collection<FederatedUserConsentClientScopeEntity> grantedClientScopeEntities = entity.getGrantedClientScopes();
        if (grantedClientScopeEntities != null) {
            for (FederatedUserConsentClientScopeEntity grantedClientScope : grantedClientScopeEntities) {
                ClientScopeModel grantedClientScopeModel = realm.getClientScopeById(grantedClientScope.getScopeId());
                if (grantedClientScopeModel == null) {
                    grantedClientScopeModel = realm.getClientById(grantedClientScope.getScopeId());
                }
                if (grantedClientScopeModel == null) continue;
                model.addGrantedClientScope(grantedClientScopeModel);
            }
        }
        return model;
    }

    private void updateGrantedConsentEntity(FederatedUserConsentEntity consentEntity, UserConsentModel consentModel) {
        Collection<FederatedUserConsentClientScopeEntity> grantedClientScopeEntities = consentEntity.getGrantedClientScopes();
        HashSet<FederatedUserConsentClientScopeEntity> scopesToRemove = new HashSet<FederatedUserConsentClientScopeEntity>(grantedClientScopeEntities);
        for (ClientScopeModel clientScope : consentModel.getGrantedClientScopes()) {
            FederatedUserConsentClientScopeEntity grantedClientScopeEntity = new FederatedUserConsentClientScopeEntity();
            grantedClientScopeEntity.setUserConsent(consentEntity);
            grantedClientScopeEntity.setScopeId(clientScope.getId());
            if (!grantedClientScopeEntities.contains(grantedClientScopeEntity)) {
                this.em.persist((Object)grantedClientScopeEntity);
                this.em.flush();
                grantedClientScopeEntities.add(grantedClientScopeEntity);
                continue;
            }
            scopesToRemove.remove(grantedClientScopeEntity);
        }
        for (FederatedUserConsentClientScopeEntity toRemove : scopesToRemove) {
            grantedClientScopeEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        consentEntity.setLastUpdatedDate(Time.currentTimeMillis());
        this.em.flush();
    }

    public void setNotBeforeForUser(RealmModel realm, String userId, int notBefore) {
        String notBeforeStr = String.valueOf(notBefore);
        this.setSingleAttribute(realm, userId, "fedNotBefore", notBeforeStr);
    }

    public int getNotBeforeOfUser(RealmModel realm, String userId) {
        MultivaluedHashMap<String, String> attrs = this.getAttributes(realm, userId);
        String notBeforeStr = (String)attrs.getFirst((Object)"fedNotBefore");
        return notBeforeStr == null ? 0 : Integer.parseInt(notBeforeStr);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("feduserGroupMembership", FederatedUserGroupMembershipEntity.class);
        query.setParameter("userId", (Object)userId);
        return StreamsUtil.closing(query.getResultStream().map(FederatedUserGroupMembershipEntity::getGroupId).map(arg_0 -> ((RealmModel)realm).getGroupById(arg_0)));
    }

    public void joinGroup(RealmModel realm, String userId, GroupModel group) {
        this.createIndex(realm, userId);
        FederatedUserGroupMembershipEntity entity = new FederatedUserGroupMembershipEntity();
        entity.setUserId(userId);
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        entity.setGroupId(group.getId());
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
    }

    public void leaveGroup(RealmModel realm, String userId, GroupModel group) {
        if (userId == null || group == null) {
            return;
        }
        TypedQuery query1 = this.em.createNamedQuery("feduserMemberOf", FederatedUserGroupMembershipEntity.class);
        query1.setParameter("userId", (Object)userId);
        query1.setParameter("groupId", (Object)group.getId());
        TypedQuery query = query1;
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (FederatedUserGroupMembershipEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public Stream<String> getMembershipStream(RealmModel realm, GroupModel group, Integer firstResult, Integer max) {
        TypedQuery query = this.em.createNamedQuery("fedgroupMembership", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("groupId", (Object)group.getId());
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, firstResult, max).getResultStream());
    }

    public Stream<String> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer max) {
        TypedQuery query = this.em.createNamedQuery("fedRoleMembership", String.class);
        query.setParameter("roleId", (Object)role.getId());
        query.setParameter("realmId", (Object)realm.getId());
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, firstResult, max).getResultStream());
    }

    public Stream<String> getRequiredActionsStream(RealmModel realm, String userId) {
        return this.getRequiredActionEntitiesStream(realm, userId, LockModeType.NONE).map(FederatedUserRequiredActionEntity::getAction).distinct();
    }

    private Stream<FederatedUserRequiredActionEntity> getRequiredActionEntitiesStream(RealmModel realm, String userId, LockModeType lockMode) {
        TypedQuery query = this.em.createNamedQuery("getFederatedUserRequiredActionsByUser", FederatedUserRequiredActionEntity.class).setParameter("userId", (Object)userId).setParameter("realmId", (Object)realm.getId());
        query.setLockMode(lockMode);
        return StreamsUtil.closing((Stream)query.getResultStream());
    }

    public void addRequiredAction(RealmModel realm, String userId, String action) {
        FederatedUserRequiredActionEntity.Key key = new FederatedUserRequiredActionEntity.Key(userId, action);
        if (this.em.find(FederatedUserRequiredActionEntity.class, (Object)key) == null) {
            this.createIndex(realm, userId);
            FederatedUserRequiredActionEntity entity = new FederatedUserRequiredActionEntity();
            entity.setUserId(userId);
            entity.setRealmId(realm.getId());
            entity.setStorageProviderId(new StorageId(userId).getProviderId());
            entity.setAction(action);
            this.em.persist((Object)entity);
        }
    }

    public void removeRequiredAction(RealmModel realm, String userId, String action) {
        this.getRequiredActionEntitiesStream(realm, userId, LockModeType.PESSIMISTIC_WRITE).filter(entity -> Objects.equals(entity.getAction(), action)).collect(Collectors.toList()).forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0));
        this.em.flush();
    }

    public void grantRole(RealmModel realm, String userId, RoleModel role) {
        this.createIndex(realm, userId);
        FederatedUserRoleMappingEntity entity = new FederatedUserRoleMappingEntity();
        entity.setUserId(userId);
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        entity.setRealmId(realm.getId());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
    }

    public Stream<RoleModel> getRoleMappingsStream(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("feduserRoleMappings", FederatedUserRoleMappingEntity.class);
        query.setParameter("userId", (Object)userId);
        return StreamsUtil.closing(query.getResultStream().map(FederatedUserRoleMappingEntity::getRoleId).map(arg_0 -> ((RealmModel)realm).getRoleById(arg_0)));
    }

    public void deleteRoleMapping(RealmModel realm, String userId, RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("feduserRoleMappings", FederatedUserRoleMappingEntity.class);
        query.setParameter("userId", (Object)userId);
        List results = query.getResultList();
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        for (FederatedUserRoleMappingEntity entity : results) {
            if (!entity.getRoleId().equals(role.getId())) continue;
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public void updateCredential(RealmModel realm, String userId, CredentialModel cred) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)cred.getId());
        if (!this.checkCredentialEntity(entity, userId)) {
            return;
        }
        this.validateDuplicateUserCredential(userId, cred.getUserLabel(), cred.getId());
        this.createIndex(realm, userId);
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setType(cred.getType());
        entity.setCredentialData(cred.getCredentialData());
        entity.setSecretData(cred.getSecretData());
        entity.setUserLabel(cred.getUserLabel());
    }

    private void validateDuplicateUserCredential(String userId, String userLabel, String credentialId) {
        boolean exists;
        if (userLabel != null && (exists = this.getStoredCredentialEntitiesStream(userId).anyMatch(existing -> existing.getUserLabel() != null && existing.getUserLabel().trim().equalsIgnoreCase(userLabel.trim()) && (credentialId == null || !existing.getId().equals(credentialId))))) {
            throw new ModelDuplicateException("Device already exists with the same name", "userLabel");
        }
    }

    public CredentialModel createCredential(RealmModel realm, String userId, CredentialModel cred) {
        this.validateDuplicateUserCredential(userId, cred.getUserLabel(), null);
        this.createIndex(realm, userId);
        FederatedUserCredentialEntity entity = new FederatedUserCredentialEntity();
        String id = cred.getId() == null ? KeycloakModelUtils.generateId() : cred.getId();
        entity.setId(id);
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setType(cred.getType());
        entity.setCredentialData(cred.getCredentialData());
        entity.setSecretData(cred.getSecretData());
        entity.setUserLabel(cred.getUserLabel());
        entity.setUserId(userId);
        entity.setRealmId(realm.getId());
        entity.setStorageProviderId(new StorageId(userId).getProviderId());
        List credentials = this.getStoredCredentialEntitiesStream(userId).collect(Collectors.toList());
        int priority = credentials.isEmpty() ? 10 : ((FederatedUserCredentialEntity)credentials.get(credentials.size() - 1)).getPriority() + 10;
        entity.setPriority(priority);
        this.em.persist((Object)entity);
        return this.toModel(entity);
    }

    public boolean removeStoredCredential(RealmModel realm, String userId, String id) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (!this.checkCredentialEntity(entity, userId)) {
            return false;
        }
        int currentPriority = entity.getPriority();
        this.getStoredCredentialEntitiesStream(userId).filter(credentialEntity -> credentialEntity.getPriority() > currentPriority).forEach(credentialEntity -> credentialEntity.setPriority(credentialEntity.getPriority() - 10));
        this.em.remove((Object)entity);
        return true;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, String userId, String id) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)id);
        if (!this.checkCredentialEntity(entity, userId)) {
            return null;
        }
        CredentialModel model = this.toModel(entity);
        return model;
    }

    private boolean checkCredentialEntity(FederatedUserCredentialEntity entity, String userId) {
        return entity != null && entity.getUserId() != null && entity.getUserId().equals(userId);
    }

    protected CredentialModel toModel(FederatedUserCredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setType(entity.getType());
        model.setCreatedDate(entity.getCreatedDate());
        model.setUserLabel(entity.getUserLabel());
        if (entity.getSalt() != null) {
            String newSecretData = entity.getSecretData().replace("__SALT__", Base64.encodeBytes((byte[])entity.getSalt()));
            entity.setSecretData(newSecretData);
            entity.setSalt(null);
        }
        model.setSecretData(entity.getSecretData());
        model.setCredentialData(entity.getCredentialData());
        return model;
    }

    public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, String userId) {
        return this.getStoredCredentialEntitiesStream(userId).map(this::toModel);
    }

    private Stream<FederatedUserCredentialEntity> getStoredCredentialEntitiesStream(String userId) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByUser", FederatedUserCredentialEntity.class).setParameter("userId", (Object)userId);
        return StreamsUtil.closing((Stream)query.getResultStream());
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, String userId, String type) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByUserAndType", FederatedUserCredentialEntity.class).setParameter("type", (Object)type).setParameter("userId", (Object)userId);
        return StreamsUtil.closing(query.getResultStream().map(this::toModel));
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, String userId, String name, String type) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByNameAndType", FederatedUserCredentialEntity.class).setParameter("type", (Object)type).setParameter("userLabel", (Object)name).setParameter("userId", (Object)userId);
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return this.toModel((FederatedUserCredentialEntity)results.get(0));
    }

    public Stream<String> getStoredUsersStream(RealmModel realm, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("getFederatedUserIds", String.class).setParameter("realmId", (Object)realm.getId());
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, first, max).getResultStream());
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.updateCredential(realm, user.getId(), cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        return this.createCredential(realm, user.getId(), cred);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        return this.removeStoredCredential(realm, user.getId(), id);
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.getStoredCredentialById(realm, user.getId(), id);
    }

    public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, UserModel user) {
        return this.getStoredCredentialsStream(realm, user.getId());
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, UserModel user, String type) {
        return this.getStoredCredentialsByTypeStream(realm, user.getId(), type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.getStoredCredentialByNameAndType(realm, user.getId(), name, type);
    }

    public boolean moveCredentialTo(RealmModel realm, UserModel user, String id, String newPreviousCredentialId) {
        List newList = this.getStoredCredentialEntitiesStream(user.getId()).collect(Collectors.toList());
        int ourCredentialIndex = -1;
        int newPreviousCredentialIndex = -1;
        FederatedUserCredentialEntity ourCredential = null;
        int i = 0;
        for (FederatedUserCredentialEntity credential : newList) {
            if (id.equals(credential.getId())) {
                ourCredentialIndex = i;
                ourCredential = credential;
            } else if (newPreviousCredentialId != null && newPreviousCredentialId.equals(credential.getId())) {
                newPreviousCredentialIndex = i;
            }
            ++i;
        }
        if (ourCredentialIndex == -1) {
            logger.warnf("Not found credential with id [%s] of user [%s]", (Object)id, (Object)user.getUsername());
            return false;
        }
        if (newPreviousCredentialId != null && newPreviousCredentialIndex == -1) {
            logger.warnf("Can't move up credential with id [%s] of user [%s]", (Object)id, (Object)user.getUsername());
            return false;
        }
        int toMoveIndex = newPreviousCredentialId == null ? 0 : newPreviousCredentialIndex + 1;
        newList.add(toMoveIndex, ourCredential);
        int indexToRemove = toMoveIndex < ourCredentialIndex ? ourCredentialIndex + 1 : ourCredentialIndex;
        newList.remove(indexToRemove);
        int expectedPriority = 0;
        for (FederatedUserCredentialEntity credential : newList) {
            if (credential.getPriority() == (expectedPriority += 10)) continue;
            credential.setPriority(expectedPriority);
            logger.tracef("Priority of credential [%s] of user [%s] changed to [%d]", (Object)credential.getId(), (Object)user.getUsername(), (Object)expectedPriority);
        }
        return true;
    }

    public int getStoredUsersCount(RealmModel realm) {
        Object count = this.em.createNamedQuery("getFederatedUserCount").setParameter("realmId", (Object)realm.getId()).getSingleResult();
        return ((Number)count).intValue();
    }

    public void preRemove(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteFederatedUserConsentClientScopesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserConsentsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserRequiredActionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteBrokerLinkByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserCredentialsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserFederatedAttributesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserGroupMembershipByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUsersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.em.createNamedQuery("deleteFederatedUserGroupMembershipsByGroup").setParameter("groupId", (Object)group.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        StorageId clientStorageId = new StorageId(client.getId());
        if (clientStorageId.isLocal()) {
            this.em.createNamedQuery("deleteFederatedUserConsentClientScopesByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserConsentsByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        } else {
            this.em.createNamedQuery("deleteFederatedUserConsentClientScopesByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserConsentsByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
    }

    public void preRemove(ClientScopeModel clientScope) {
        this.em.createNamedQuery("deleteFederatedUserConsentClientScopesByClientScope").setParameter("scopeId", (Object)clientScope.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, UserModel user) {
        this.em.createNamedQuery("deleteBrokerLinkByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserFederatedAttributesByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentClientScopesByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserCredentialByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserGroupMembershipsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRequiredActionsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ComponentModel model) {
        if (model.getProviderType().equals(UserStorageProvider.class.getName())) {
            this.em.createNamedQuery("deleteBrokerLinkByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedAttributesByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserConsentClientScopesByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserConsentsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserCredentialsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserGroupMembershipByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserRequiredActionsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserRoleMappingsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUsersByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        } else if (model.getProviderType().equals(ClientStorageProvider.class.getName())) {
            this.em.createNamedQuery("deleteFederatedUserConsentClientScopesByClientStorageProvider").setParameter("clientStorageProvider", (Object)model.getId()).executeUpdate();
            this.em.createNamedQuery("deleteFederatedUserConsentsByClientStorageProvider").setParameter("clientStorageProvider", (Object)model.getId()).executeUpdate();
        }
    }
}

