/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.script;

import java.util.List;
import java.util.Map;
import org.opensearch.core.common.Strings;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;
import org.opensearch.knn.index.SpaceType;

public class KNNPainlessScriptUtils {
    public static float lateInteractionScore(List<List<Number>> queryVectors, String docFieldName, Map<String, Object> doc) {
        return KNNPainlessScriptUtils.lateInteractionScore(queryVectors, docFieldName, doc, SpaceType.DEFAULT.getValue());
    }

    public static float lateInteractionScore(List<List<Number>> queryVectors, String docFieldName, Map<String, Object> doc, String spaceType) {
        List docVectors;
        KNNPainlessScriptUtils.validateInputs(queryVectors, docFieldName, doc, spaceType);
        try {
            docVectors = (List)doc.get(docFieldName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Field " + docFieldName + " must contain a list of vector lists", e);
        }
        if (docVectors == null || docVectors.isEmpty()) {
            throw new IllegalArgumentException("Document vectors cannot be null or empty");
        }
        SpaceType space = SpaceType.getSpace(spaceType);
        KNNVectorSimilarityFunction similarityFunction = space.getKnnVectorSimilarityFunction();
        if (similarityFunction == null) {
            throw new IllegalArgumentException("Space type " + spaceType + " does not support vector similarity function");
        }
        float totalScore = 0.0f;
        for (List<Number> queryVector : queryVectors) {
            if (queryVector == null || queryVector.isEmpty()) {
                throw new IllegalArgumentException("Every single vector within query vectors cannot be empty or null");
            }
            float[] qVec = new float[queryVector.size()];
            for (int i = 0; i < queryVector.size(); ++i) {
                qVec[i] = queryVector.get(i).floatValue();
            }
            float bestRawScore = (float)docVectors.stream().filter(docVector -> docVector != null && !docVector.isEmpty()).mapToDouble(docVector -> {
                float[] dVec = new float[docVector.size()];
                for (int i = 0; i < docVector.size(); ++i) {
                    dVec[i] = ((Number)docVector.get(i)).floatValue();
                }
                return similarityFunction.compare(qVec, dVec);
            }).max().orElse(Double.NEGATIVE_INFINITY);
            if ((double)bestRawScore == Double.NEGATIVE_INFINITY) continue;
            totalScore += bestRawScore;
        }
        return totalScore;
    }

    private static void validateInputs(List<List<Number>> queryVectors, String docFieldName, Map<String, Object> doc, String spaceType) {
        if (queryVectors == null) {
            throw new IllegalArgumentException("Query vectors cannot be null");
        }
        if (queryVectors.isEmpty()) {
            throw new IllegalArgumentException("Query vectors cannot be empty");
        }
        if (Strings.isNullOrEmpty((String)docFieldName)) {
            throw new IllegalArgumentException("Document field name cannot be null or empty");
        }
        if (doc == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        if (Strings.isNullOrEmpty((String)spaceType)) {
            throw new IllegalArgumentException("Space type cannot be null or empty");
        }
    }
}

