/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.LongEdgeJoiner;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.LabelSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LabelDummyRemover
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label dummy removal", 1.0f);
        double edgeLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_LABEL);
        double labelLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
        Direction layoutDirection = layeredGraph.getProperty(LayeredOptions.DIRECTION);
        for (Layer layer : layeredGraph.getLayers()) {
            ListIterator<LNode> nodeIterator = layer.getNodes().listIterator();
            while (nodeIterator.hasNext()) {
                LNode node = nodeIterator.next();
                if (node.getType() != LNode.NodeType.LABEL) continue;
                LEdge originEdge = (LEdge)node.getProperty(InternalProperties.ORIGIN);
                double thickness = originEdge.getProperty(LayeredOptions.EDGE_THICKNESS);
                boolean labelsBelowEdge = node.getProperty(InternalProperties.LABEL_SIDE) == LabelSide.BELOW;
                KVector currLabelPos = new KVector(node.getPosition());
                if (labelsBelowEdge) {
                    currLabelPos.y += thickness + edgeLabelSpacing;
                }
                KVector labelSpace = new KVector(node.getSize().x, node.getSize().y + (node.isInlineEdgeLabel() ? 0.0 : -thickness - edgeLabelSpacing));
                List<LLabel> representedLabels = node.getProperty(InternalProperties.REPRESENTED_LABELS);
                if (layoutDirection.isVertical()) {
                    this.placeLabelsForVerticalLayout(representedLabels, currLabelPos, labelLabelSpacing, labelSpace, labelsBelowEdge, layoutDirection);
                } else {
                    this.placeLabelsForHorizontalLayout(representedLabels, currLabelPos, labelLabelSpacing, labelSpace);
                }
                originEdge.getLabels().addAll(representedLabels);
                LongEdgeJoiner.joinAt(node, layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.POLYLINE);
                nodeIterator.remove();
            }
        }
        monitor.done();
    }

    private void placeLabelsForHorizontalLayout(List<LLabel> labels, KVector labelPos, double labelSpacing, KVector labelSpace) {
        for (LLabel label : labels) {
            label.getPosition().x = labelPos.x + (labelSpace.x - label.getSize().x) / 2.0;
            label.getPosition().y = labelPos.y;
            labelPos.y += label.getSize().y + labelSpacing;
        }
    }

    private void placeLabelsForVerticalLayout(List<LLabel> labels, KVector labelPos, double labelSpacing, KVector labelSpace, boolean leftAligned, Direction layoutDirection) {
        boolean inline = labels.stream().allMatch(label -> label.getProperty(LayeredOptions.EDGE_LABELS_INLINE));
        List<LLabel> effectiveLabels = labels;
        if (layoutDirection == Direction.UP) {
            effectiveLabels = Lists.reverse(effectiveLabels);
        }
        for (LLabel label2 : effectiveLabels) {
            label2.getPosition().x = labelPos.x;
            label2.getPosition().y = inline ? labelPos.y + (labelSpace.y - label2.getSize().y) / 2.0 : (leftAligned ? labelPos.y : labelPos.y + labelSpace.y - label2.getSize().y);
            labelPos.x += label2.getSize().x + labelSpacing;
        }
    }
}

