\name{BinaryThinningImageFilter}
\alias{BinaryThinningImageFilter}
\title{BinaryThinningImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter computes one-pixel-wide edges of the input image.
BinaryThinningImageFilter}
\details{
This class is parameterized over the type of the input image and the
type of the output image.
The input is assumed to be a binary image. If the foreground pixels of
the input image do not have a value of 1, they are rescaled to 1
internally to simplify the computation.
The filter will produce a skeleton of the object. The output
background values are 0, and the foreground values are 1.
This filter is a sequential thinning algorithm and known to be
computational time dependable on the image size. The algorithm
corresponds with the 2D implementation described in:
Rafael C. Gonzales and Richard E. Woods. Digital Image Processing. Addison Wesley, 491-494, (1993).
To do: Make this filter ND.
See:
MorphologyImageFilter
BinaryThinning for the procedural interface
itk::BinaryThinningImageFilter for the Doxygen on the original ITK class.
BinaryThinningImageFilter}
%C++ includes: sitkBinaryThinningImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryThinningImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryThinningImageFilter():}{
Destructor
}
}
}
